<?php

class Application_Model_Permission extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_permission';

    private $_id = null;

    private $_permission_title = null;

    private $_permission_key = null;

    private $_permission_updated_by = null;

    private $_permission_updated_date = null;

    private $_permission_created_by = null;

    private $_permission_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get permission_title method is stand for get the value of permission_title.
     *
     * @var varchar permission_title
     */
    public function get_permission_title()
    {
        return $this->_permission_title;
    }

    /**
     * set permission_title method is stand for set the value of permission_title.
     *
     * @var varchar permission_title
     */
    public function set_permission_title($value)
    {
        $this->_permission_title = $value;
    }

    /**
     * get permission_key method is stand for get the value of permission_key.
     *
     * @var varchar permission_key
     */
    public function get_permission_key()
    {
        return $this->_permission_key;
    }

    /**
     * set permission_key method is stand for set the value of permission_key.
     *
     * @var varchar permission_key
     */
    public function set_permission_key($value)
    {
        $this->_permission_key = $value;
    }

    /**
     * get permission_updated_by method is stand for get the value of
     * permission_updated_by.
     *
     * @var int permission_updated_by
     */
    public function get_permission_updated_by()
    {
        return (int) $this->_permission_updated_by;
    }

    /**
     * set permission_updated_by method is stand for set the value of
     * permission_updated_by.
     *
     * @var int permission_updated_by
     */
    public function set_permission_updated_by($value)
    {
        $this->_permission_updated_by = (int) $value;
    }

    /**
     * get permission_updated_date method is stand for get the value of
     * permission_updated_date.
     *
     * @var timestamp permission_updated_date
     */
    public function get_permission_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_permission_updated_date));
    }

    /**
     * set permission_updated_date method is stand for set the value of
     * permission_updated_date.
     *
     * @var timestamp permission_updated_date
     */
    public function set_permission_updated_date($value)
    {
        $this->_permission_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get permission_created_by method is stand for get the value of
     * permission_created_by.
     *
     * @var int permission_created_by
     */
    public function get_permission_created_by()
    {
        return (int) $this->_permission_created_by;
    }

    /**
     * set permission_created_by method is stand for set the value of
     * permission_created_by.
     *
     * @var int permission_created_by
     */
    public function set_permission_created_by($value)
    {
        $this->_permission_created_by = (int) $value;
    }

    /**
     * get permission_created_date method is stand for get the value of
     * permission_created_date.
     *
     * @var timestamp permission_created_date
     */
    public function get_permission_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_permission_created_date));
    }

    /**
     * set permission_created_date method is stand for set the value of
     * permission_created_date.
     *
     * @var timestamp permission_created_date
     */
    public function set_permission_created_date($value)
    {
        $this->_permission_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_permission by set id thru constructor.
     *
     * @var int id
     * @var varchar permission_title
     * @var varchar permission_key
     * @var int permission_updated_by
     * @var timestamp permission_updated_date
     * @var int permission_created_by
     * @var timestamp permission_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_permission_title($row->permission_title);
          $this->set_permission_key($row->permission_key);
          $this->set_permission_updated_by($row->permission_updated_by);
          $this->set_permission_updated_date($row->permission_updated_date);
          $this->set_permission_created_by($row->permission_created_by);
          $this->set_permission_created_date($row->permission_created_date);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var varchar permission_title
     * @var varchar permission_key
     * @var int permission_updated_by
     * @var int permission_created_by
     */
    public function save()
    {
        $data = array(
          "permission_title" => $this->get_permission_title(),
          "permission_key" => $this->get_permission_key(),
          "permission_updated_by" => $this->get_permission_updated_by(),
          "permission_created_by" => $this->get_permission_created_by());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from asit_permission by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_permission_title_by_id method is stand for get the value ofpermission_title
     * By id.
     *
     * @var varchar permission_title
     */
    public function get_permission_title_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_permission_title();
    }

    /**
     * get_permission_key_by_id method is stand for get the value ofpermission_key By
     * id.
     *
     * @var varchar permission_key
     */
    public function get_permission_key_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_permission_key();
    }

    /**
     * get_permission_updated_by_by_id method is stand for get the value
     * ofpermission_updated_by By id.
     *
     * @var int permission_updated_by
     */
    public function get_permission_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_permission_updated_by();
    }

    /**
     * get_permission_updated_date_by_id method is stand for get the value
     * ofpermission_updated_date By id.
     *
     * @var timestamp permission_updated_date
     */
    public function get_permission_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_permission_updated_date()));
    }

    /**
     * get_permission_created_by_by_id method is stand for get the value
     * ofpermission_created_by By id.
     *
     * @var int permission_created_by
     */
    public function get_permission_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_permission_created_by();
    }

    /**
     * get_permission_created_date_by_id method is stand for get the value
     * ofpermission_created_date By id.
     *
     * @var timestamp permission_created_date
     */
    public function get_permission_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_permission_created_date()));
    }


}
