<?php

class Application_Model_PermissionLogic extends Application_Model_Permission
{
    
    public function fetchOrdered()
    {
        return $this->fetchAll($this->select()->order('permission_title'));
    }

    public function getIdByKey($key)
    {
        $where = $this->select()->where('permission_key = ?', $key);
        $result = $this->fetchRow($where);
        return ((!empty($result)) ? $result->id : 0);
    }

    public function fetchDataTableSelect() 
    {
        $columns = array('permission_title', 'permission_key', 'action');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_PermissionLogic(-1)), $columns);
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        $url = new Zend_View_Helper_Url();
        $enc = new Application_Model_Util_Encrypt();
        foreach($rows as $row)
        {
            $action = '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"permission", "action"=>"edit", "id"=>$enc->hideContent($row->id))).'"><input type="button" value="Edit" class="btn btn-info" /></a> '
                    . '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"permission", "action"=>"delete", "id"=>$enc->hideContent($row->id))).'"><input type="button" value="Delete" class="btn btn-danger" /></a>';
            $results[$i] = array($row->permission_title, $row->permission_key, $action);
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }

}

