<?php

class Application_Model_Review extends Zend_Db_Table_Abstract
{
    
    protected $_name = 'asit_list_review';
    
    private $_id = null;
    
    private $_review_list = null;
    
    private $_review_user = null;
    
    private $_review_score = null;
    
    private $_review_subject = null;
    
    private $_review_body = null;
    
    private $_review_status = null;
    
    private $_review_updated_by = null;
    
    private $_review_updated_date = null;
    
    private $_review_created_by = null;
    
    private $_review_created_date = null;
    
    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
            $this->fetch();
        }
    }
    
    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }
    
    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }
    
    /**
     * get review_list method is stand for get the value of review_list.
     *
     * @var int review_list
     */
    public function get_review_list()
    {
        return (int) $this->_review_list;
    }
    
    /**
     * set review_list method is stand for set the value of review_list.
     *
     * @var int review_list
     */
    public function set_review_list($value)
    {
        $this->_review_list = (int) $value;
    }
    
    /**
     * get review_user method is stand for get the value of review_user.
     *
     * @var int review_user
     */
    public function get_review_user()
    {
        return (int) $this->_review_user;
    }
    
    /**
     * set review_user method is stand for set the value of review_user.
     *
     * @var int review_user
     */
    public function set_review_user($value)
    {
        $this->_review_user = (int) $value;
    }
    
    /**
     * get review_score method is stand for get the value of review_score.
     *
     * @var tinyint review_score
     */
    public function get_review_score()
    {
        return $this->_review_score;
    }
    
    /**
     * set review_score method is stand for set the value of review_score.
     *
     * @var tinyint review_score
     */
    public function set_review_score($value)
    {
        $this->_review_score = $value;
    }
    
    /**
     * get review_subject method is stand for get the value of review_subject.
     *
     * @var varchar review_subject
     */
    public function get_review_subject()
    {
        return $this->_review_subject;
    }
    
    /**
     * set review_subject method is stand for set the value of review_subject.
     *
     * @var varchar review_subject
     */
    public function set_review_subject($value)
    {
        $this->_review_subject = $value;
    }
    
    /**
     * get review_body method is stand for get the value of review_body.
     *
     * @var text review_body
     */
    public function get_review_body()
    {
        return $this->_review_body;
    }
    
    /**
     * set review_body method is stand for set the value of review_body.
     *
     * @var text review_body
     */
    public function set_review_body($value)
    {
        $this->_review_body = $value;
    }
    
    /**
     * get review_status method is stand for get the value of review_status.
     *
     * @var varchar review_status
     */
    public function get_review_status()
    {
        return $this->_review_status;
    }
    
    /**
     * set review_status method is stand for set the value of review_status.
     *
     * @var varchar review_status
     */
    public function set_review_status($value)
    {
        $this->_review_status = $value;
    }
    
    /**
     * get review_updated_by method is stand for get the value of review_updated_by.
     *
     * @var int review_updated_by
     */
    public function get_review_updated_by()
    {
        return (int) $this->_review_updated_by;
    }
    
    /**
     * set review_updated_by method is stand for set the value of review_updated_by.
     *
     * @var int review_updated_by
     */
    public function set_review_updated_by($value)
    {
        $this->_review_updated_by = (int) $value;
    }
    
    /**
     * get review_updated_date method is stand for get the value of
     * review_updated_date.
     *
     * @var timestamp review_updated_date
     */
    public function get_review_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_review_updated_date));
    }
    
    /**
     * set review_updated_date method is stand for set the value of
     * review_updated_date.
     *
     * @var timestamp review_updated_date
     */
    public function set_review_updated_date($value)
    {
        $this->_review_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }
    
    /**
     * get review_created_by method is stand for get the value of review_created_by.
     *
     * @var int review_created_by
     */
    public function get_review_created_by()
    {
        return (int) $this->_review_created_by;
    }
    
    /**
     * set review_created_by method is stand for set the value of review_created_by.
     *
     * @var int review_created_by
     */
    public function set_review_created_by($value)
    {
        $this->_review_created_by = (int) $value;
    }
    
    /**
     * get review_created_date method is stand for get the value of
     * review_created_date.
     *
     * @var timestamp review_created_date
     */
    public function get_review_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_review_created_date));
    }
    
    /**
     * set review_created_date method is stand for set the value of
     * review_created_date.
     *
     * @var timestamp review_created_date
     */
    public function set_review_created_date($value)
    {
        $this->_review_created_date = date("Y-m-d H:i:s", strtotime($value));
    }
    
    /**
     * fetch data from asit_list_review by set id thru constructor.
     *
     * @var int id
     * @var int review_list
     * @var int review_user
     * @var tinyint review_score
     * @var varchar review_subject
     * @var text review_body
     * @var varchar review_status
     * @var int review_updated_by
     * @var timestamp review_updated_date
     * @var int review_created_by
     * @var timestamp review_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
            $this->set_id($row->id);
            $this->set_review_list($row->review_list);
            $this->set_review_user($row->review_user);
            $this->set_review_score($row->review_score);
            $this->set_review_subject($row->review_subject);
            $this->set_review_body($row->review_body);
            $this->set_review_status($row->review_status);
            $this->set_review_updated_by($row->review_updated_by);
            $this->set_review_updated_date($row->review_updated_date);
            $this->set_review_created_by($row->review_created_by);
            $this->set_review_created_date($row->review_created_date);
        }
    }
    
    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var int review_list
     * @var int review_user
     * @var tinyint review_score
     * @var varchar review_subject
     * @var text review_body
     * @var varchar review_status
     * @var int review_updated_by
     * @var int review_created_by
     */
    public function save()
    {
        $data = array(
            "review_list" => $this->get_review_list(),
            "review_user" => $this->get_review_user(),
            "review_score" => $this->get_review_score(),
            "review_subject" => $this->get_review_subject(),
            "review_body" => $this->get_review_body(),
            "review_status" => $this->get_review_status(),
            "review_updated_by" => $this->get_review_updated_by(),
            "review_created_by" => $this->get_review_created_by());
        if($this->get_id()==-1)
        {
            return $this->insert($data);
        }
        else
        {
            $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
            $this->update($data, $where);
        }
    }
    
    /**
     * remove method delete the record from asit_list_review by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }
    
    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }
    
    /**
     * get_review_list_by_id method is stand for get the value ofreview_list By id.
     *
     * @var int review_list
     */
    public function get_review_list_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_review_list();
    }
    
    /**
     * get_review_user_by_id method is stand for get the value ofreview_user By id.
     *
     * @var int review_user
     */
    public function get_review_user_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_review_user();
    }
    
    /**
     * get_review_score_by_id method is stand for get the value ofreview_score By id.
     *
     * @var tinyint review_score
     */
    public function get_review_score_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_review_score();
    }
    
    /**
     * get_review_subject_by_id method is stand for get the value ofreview_subject By
     * id.
     *
     * @var varchar review_subject
     */
    public function get_review_subject_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_review_subject();
    }
    
    /**
     * get_review_body_by_id method is stand for get the value ofreview_body By id.
     *
     * @var text review_body
     */
    public function get_review_body_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_review_body();
    }
    
    /**
     * get_review_status_by_id method is stand for get the value ofreview_status By id.
     *
     * @var varchar review_status
     */
    public function get_review_status_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_review_status();
    }
    
    /**
     * get_review_updated_by_by_id method is stand for get the value
     * ofreview_updated_by By id.
     *
     * @var int review_updated_by
     */
    public function get_review_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_review_updated_by();
    }
    
    /**
     * get_review_updated_date_by_id method is stand for get the value
     * ofreview_updated_date By id.
     *
     * @var timestamp review_updated_date
     */
    public function get_review_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_review_updated_date()));
    }
    
    /**
     * get_review_created_by_by_id method is stand for get the value
     * ofreview_created_by By id.
     *
     * @var int review_created_by
     */
    public function get_review_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_review_created_by();
    }
    
    /**
     * get_review_created_date_by_id method is stand for get the value
     * ofreview_created_date By id.
     *
     * @var timestamp review_created_date
     */
    public function get_review_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_review_created_date()));
    }
    
    
}
