<?php

class Application_Model_ReviewLogic extends Application_Model_Review
{
    public function fetchDataTableSelect($id = null)
    {
        $columns = array('user_name', 'review_subject', 'review_status', 'action');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_ReviewLogic(-1)), $columns);
        $where = $obj_data->get_where();
        $where->from(array("r"=>$this->_name, "u"=>"asit_user"), 
                array("r.id", "u.user_name", "r.review_subject", 'r.review_status'));
        $where->joinLeft(array("u"=>"asit_user"),
                'r.review_user = u.id', array())
                ->setIntegrityCheck(false);
        $where->where('r.review_status != ?', 'D');
        if($id != null) {
            $where->where('r.review_list = ?', $id);
        }
        $obj_data->set_where($where);
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        $url = new Zend_View_Helper_Url();
        foreach($rows as $row)
        {
            $action = '';
            if(Application_Model_RolePermissionLogic::isPermitted("Review:Edit")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"review", "action"=>"edit", "id"=>$row->id)).'"><input type="button" value="Edit" class="btn btn-info" /></a>';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("Review:Delete")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"review", "action"=>"delete", "id"=>$row->id)).'"><input type="button" value="Delete" class="btn btn-danger" /></a>';
            }
            $results[$i] = array($row->user_name, $row->review_subject, $row->review_status, $action);
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }
    
    public function getReviewsByList($listId) {
        $sql = "select r.*, u.user_name from ".$this->_name." r left join asit_user u on (r.review_user = u.id) where r.review_list = ? order by r.id desc";
        $query = $this->getAdapter()->query($sql, array($listId));
        return $query->fetchAll();
    }
    
    public function getAvgReview($listId) {
        $sql = "SELECT AVG(review_score) as score, count(*) as total FROM ".$this->_name." where review_list = ?";
        $query = $this->getAdapter()->query($sql, array($listId));
        return $query->fetch();
    }
}

