<?php

class Application_Model_Role extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_role';

    private $_id = null;

    private $_role_title = null;

    private $_role_description = null;

    private $_role_is_admin = null;

    private $_role_is_register = null;

    private $_role_updated_by = null;

    private $_role_updated_date = null;

    private $_role_created_by = null;

    private $_role_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get role_title method is stand for get the value of role_title.
     *
     * @var varchar role_title
     */
    public function get_role_title()
    {
        return $this->_role_title;
    }

    /**
     * set role_title method is stand for set the value of role_title.
     *
     * @var varchar role_title
     */
    public function set_role_title($value)
    {
        $this->_role_title = $value;
    }

    /**
     * get role_description method is stand for get the value of role_description.
     *
     * @var varchar role_description
     */
    public function get_role_description()
    {
        return $this->_role_description;
    }

    /**
     * set role_description method is stand for set the value of role_description.
     *
     * @var varchar role_description
     */
    public function set_role_description($value)
    {
        $this->_role_description = $value;
    }

    /**
     * get role_is_admin method is stand for get the value of role_is_admin.
     *
     * @var tinyint role_is_admin
     */
    public function get_role_is_admin()
    {
        return $this->_role_is_admin;
    }

    /**
     * set role_is_admin method is stand for set the value of role_is_admin.
     *
     * @var tinyint role_is_admin
     */
    public function set_role_is_admin($value)
    {
        $this->_role_is_admin = $value;
    }

    /**
     * get role_is_register method is stand for get the value of role_is_register.
     *
     * @var tinyint role_is_register
     */
    public function get_role_is_register()
    {
        return $this->_role_is_register;
    }

    /**
     * set role_is_register method is stand for set the value of role_is_register.
     *
     * @var tinyint role_is_register
     */
    public function set_role_is_register($value)
    {
        $this->_role_is_register = $value;
    }

    /**
     * get role_updated_by method is stand for get the value of role_updated_by.
     *
     * @var int role_updated_by
     */
    public function get_role_updated_by()
    {
        return (int) $this->_role_updated_by;
    }

    /**
     * set role_updated_by method is stand for set the value of role_updated_by.
     *
     * @var int role_updated_by
     */
    public function set_role_updated_by($value)
    {
        $this->_role_updated_by = (int) $value;
    }

    /**
     * get role_updated_date method is stand for get the value of role_updated_date.
     *
     * @var timestamp role_updated_date
     */
    public function get_role_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_role_updated_date));
    }

    /**
     * set role_updated_date method is stand for set the value of role_updated_date.
     *
     * @var timestamp role_updated_date
     */
    public function set_role_updated_date($value)
    {
        $this->_role_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get role_created_by method is stand for get the value of role_created_by.
     *
     * @var int role_created_by
     */
    public function get_role_created_by()
    {
        return (int) $this->_role_created_by;
    }

    /**
     * set role_created_by method is stand for set the value of role_created_by.
     *
     * @var int role_created_by
     */
    public function set_role_created_by($value)
    {
        $this->_role_created_by = (int) $value;
    }

    /**
     * get role_created_date method is stand for get the value of role_created_date.
     *
     * @var timestamp role_created_date
     */
    public function get_role_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_role_created_date));
    }

    /**
     * set role_created_date method is stand for set the value of role_created_date.
     *
     * @var timestamp role_created_date
     */
    public function set_role_created_date($value)
    {
        $this->_role_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_role by set id thru constructor.
     *
     * @var int id
     * @var varchar role_title
     * @var varchar role_description
     * @var tinyint role_is_admin
     * @var tinyint role_is_register
     * @var int role_updated_by
     * @var timestamp role_updated_date
     * @var int role_created_by
     * @var timestamp role_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_role_title($row->role_title);
          $this->set_role_description($row->role_description);
          $this->set_role_is_admin($row->role_is_admin);
          $this->set_role_is_register($row->role_is_register);
          $this->set_role_updated_by($row->role_updated_by);
          $this->set_role_updated_date($row->role_updated_date);
          $this->set_role_created_by($row->role_created_by);
          $this->set_role_created_date($row->role_created_date);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var varchar role_title
     * @var varchar role_description
     * @var tinyint role_is_admin
     * @var tinyint role_is_register
     * @var int role_updated_by
     * @var int role_created_by
     */
    public function save()
    {
        $data = array(
          "role_title" => $this->get_role_title(),
          "role_description" => $this->get_role_description(),
          "role_is_admin" => $this->get_role_is_admin(),
          "role_is_register" => $this->get_role_is_register(),
          "role_updated_by" => $this->get_role_updated_by(),
          "role_created_by" => $this->get_role_created_by());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from asit_role by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_role_title_by_id method is stand for get the value ofrole_title By id.
     *
     * @var varchar role_title
     */
    public function get_role_title_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_role_title();
    }

    /**
     * get_role_description_by_id method is stand for get the value ofrole_description
     * By id.
     *
     * @var varchar role_description
     */
    public function get_role_description_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_role_description();
    }

    /**
     * get_role_is_admin_by_id method is stand for get the value ofrole_is_admin By id.
     *
     * @var tinyint role_is_admin
     */
    public function get_role_is_admin_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_role_is_admin();
    }

    /**
     * get_role_is_register_by_id method is stand for get the value ofrole_is_register
     * By id.
     *
     * @var tinyint role_is_register
     */
    public function get_role_is_register_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_role_is_register();
    }

    /**
     * get_role_updated_by_by_id method is stand for get the value ofrole_updated_by By
     * id.
     *
     * @var int role_updated_by
     */
    public function get_role_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_role_updated_by();
    }

    /**
     * get_role_updated_date_by_id method is stand for get the value
     * ofrole_updated_date By id.
     *
     * @var timestamp role_updated_date
     */
    public function get_role_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_role_updated_date()));
    }

    /**
     * get_role_created_by_by_id method is stand for get the value ofrole_created_by By
     * id.
     *
     * @var int role_created_by
     */
    public function get_role_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_role_created_by();
    }

    /**
     * get_role_created_date_by_id method is stand for get the value
     * ofrole_created_date By id.
     *
     * @var timestamp role_created_date
     */
    public function get_role_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_role_created_date()));
    }


}
