<?php

class Application_Model_RoleLogic extends Application_Model_Role
{
    
    public function fetchOrdered()
    {
        return $this->fetchAll($this->select()->order('role_title'));
    }
    
    public function fetchDataTableSelect() 
    {
        $columns = array('role_title', 'role_description', 'role_is_admin', 'role_is_register', 'action');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_RoleLogic(-1)), $columns);
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        $url = new Zend_View_Helper_Url();
        $enc = new Application_Model_Util_Encrypt();
        foreach($rows as $row)
        {
            $action = '';
            if(Application_Model_RolePermissionLogic::isPermitted("Menu:Edit")) {
                $action = '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"role", "action"=>"edit", "id"=>$enc->hideContent($row->id))).'"><input type="button" value="Edit" class="btn btn-info" /></a> ';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("Menu:Delete")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"role", "action"=>"delete", "id"=>$enc->hideContent($row->id))).'"><input type="button" value="Delete" class="btn btn-danger" /></a>';
            }
            $results[$i] = array($row->role_title, $row->role_description, ($row->role_is_admin) ? 'true' : 'false', ($row->role_is_register) ? 'true' : 'false', $action);
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }
}

