<?php

class Application_Model_RolePermission extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_role_permission';

    private $_id = null;

    private $_role_id = null;

    private $_permission_id = null;

    private $_is_permitted = null;

    private $_updated_by = null;

    private $_updated_date = null;

    private $_created_by = null;

    private $_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get role_id method is stand for get the value of role_id.
     *
     * @var int role_id
     */
    public function get_role_id()
    {
        return (int) $this->_role_id;
    }

    /**
     * set role_id method is stand for set the value of role_id.
     *
     * @var int role_id
     */
    public function set_role_id($value)
    {
        $this->_role_id = (int) $value;
    }

    /**
     * get permission_id method is stand for get the value of permission_id.
     *
     * @var int permission_id
     */
    public function get_permission_id()
    {
        return (int) $this->_permission_id;
    }

    /**
     * set permission_id method is stand for set the value of permission_id.
     *
     * @var int permission_id
     */
    public function set_permission_id($value)
    {
        $this->_permission_id = (int) $value;
    }

    /**
     * get is_permitted method is stand for get the value of is_permitted.
     *
     * @var tinyint is_permitted
     */
    public function get_is_permitted()
    {
        return $this->_is_permitted;
    }

    /**
     * set is_permitted method is stand for set the value of is_permitted.
     *
     * @var tinyint is_permitted
     */
    public function set_is_permitted($value)
    {
        $this->_is_permitted = $value;
    }

    /**
     * get updated_by method is stand for get the value of updated_by.
     *
     * @var int updated_by
     */
    public function get_updated_by()
    {
        return (int) $this->_updated_by;
    }

    /**
     * set updated_by method is stand for set the value of updated_by.
     *
     * @var int updated_by
     */
    public function set_updated_by($value)
    {
        $this->_updated_by = (int) $value;
    }

    /**
     * get updated_date method is stand for get the value of updated_date.
     *
     * @var timestamp updated_date
     */
    public function get_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_updated_date));
    }

    /**
     * set updated_date method is stand for set the value of updated_date.
     *
     * @var timestamp updated_date
     */
    public function set_updated_date($value)
    {
        $this->_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get created_by method is stand for get the value of created_by.
     *
     * @var int created_by
     */
    public function get_created_by()
    {
        return (int) $this->_created_by;
    }

    /**
     * set created_by method is stand for set the value of created_by.
     *
     * @var int created_by
     */
    public function set_created_by($value)
    {
        $this->_created_by = (int) $value;
    }

    /**
     * get created_date method is stand for get the value of created_date.
     *
     * @var timestamp created_date
     */
    public function get_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_created_date));
    }

    /**
     * set created_date method is stand for set the value of created_date.
     *
     * @var timestamp created_date
     */
    public function set_created_date($value)
    {
        $this->_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_role_permission by set id thru constructor.
     *
     * @var int id
     * @var int role_id
     * @var int permission_id
     * @var tinyint is_permitted
     * @var int updated_by
     * @var timestamp updated_date
     * @var int created_by
     * @var timestamp created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_role_id($row->role_id);
          $this->set_permission_id($row->permission_id);
          $this->set_is_permitted($row->is_permitted);
          $this->set_updated_by($row->updated_by);
          $this->set_updated_date($row->updated_date);
          $this->set_created_by($row->created_by);
          $this->set_created_date($row->created_date);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var int role_id
     * @var int permission_id
     * @var tinyint is_permitted
     * @var int updated_by
     * @var int created_by
     */
    public function save()
    {
        $data = array(
          "role_id" => $this->get_role_id(),
          "permission_id" => $this->get_permission_id(),
          "is_permitted" => $this->get_is_permitted(),
          "updated_by" => $this->get_updated_by(),
          "created_by" => $this->get_created_by());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from asit_role_permission by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_role_id_by_id method is stand for get the value ofrole_id By id.
     *
     * @var int role_id
     */
    public function get_role_id_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_role_id();
    }

    /**
     * get_permission_id_by_id method is stand for get the value ofpermission_id By id.
     *
     * @var int permission_id
     */
    public function get_permission_id_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_permission_id();
    }

    /**
     * get_is_permitted_by_id method is stand for get the value ofis_permitted By id.
     *
     * @var tinyint is_permitted
     */
    public function get_is_permitted_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_is_permitted();
    }

    /**
     * get_updated_by_by_id method is stand for get the value ofupdated_by By id.
     *
     * @var int updated_by
     */
    public function get_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_updated_by();
    }

    /**
     * get_updated_date_by_id method is stand for get the value ofupdated_date By id.
     *
     * @var timestamp updated_date
     */
    public function get_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_updated_date()));
    }

    /**
     * get_created_by_by_id method is stand for get the value ofcreated_by By id.
     *
     * @var int created_by
     */
    public function get_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_created_by();
    }

    /**
     * get_created_date_by_id method is stand for get the value ofcreated_date By id.
     *
     * @var timestamp created_date
     */
    public function get_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_created_date()));
    }


}
