<?php

class Application_Model_RolePermissionLogic extends Application_Model_RolePermission
{

    public static function isPermitted($key = null, $user = null)
    {
        $role = 0;
        if($user == null) {
            $userSess = new Zend_Session_Namespace('user');
            $role = (int)$userSess->user_role;
        }else {
            $role = (int)$user->get_user_role();
        }
        
        if($role > 0 && $key != null) {
            $cacheUtil = new Application_Model_Cache_Role();
            $permissions = $cacheUtil->roleCache($role);
            if(array_key_exists($key, $permissions)) {
                return $permissions[$key];
            }else {
                return false;
            }
        }else {
            return false;
        }   
    }
    
    public function getPermissionsByRole($id)
    {
        $query = $this->getAdapter()->query('SELECT permission_id FROM `asit_role_permission` where role_id = ?', array($id));
        $permissions = array();
        foreach($query->fetchAll() as $row){
            array_push($permissions, $row['permission_id']);
        }
        return $permissions;
    }
    
    public function getPermissionsByRoleForCache($id)
    {
        $query = $this->getAdapter()->query('SELECT p.permission_key, rp.is_permitted FROM `asit_role_permission` rp left join asit_permission p on (rp.permission_id = p.id) where rp.role_id = ?', array($id));
        foreach($query->fetchAll() as $result)
        {
            $permissions[$result['permission_key']] = ($result['is_permitted']) ? true : false;
        }
        return $permissions;
    }
    
    public function deletePermissionByRole($id)
    {
        $where = $this->getAdapter()->quoteInto("role_id = ?", $id);
        $this->delete($where);
    }
    
    public function insertPermissionByRole($role, $permission, $user)
    {
        $this->set_id(-1);
        $this->set_role_id($role);
        $this->set_permission_id($permission);
        $this->set_is_permitted(true);
        $this->set_created_by($user);
        $this->save();
    }

}

