<?php

class Application_Model_Slider extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_slider';

    private $_id = null;

    private $_slider_title = null;

    private $_slider_image = null;

    private $_slider_status = null;

    private $_slider_updated_by = null;

    private $_slider_updated_date = null;

    private $_slider_created_by = null;

    private $_slider_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get slider_title method is stand for get the value of slider_title.
     *
     * @var varchar slider_title
     */
    public function get_slider_title()
    {
        return $this->_slider_title;
    }

    /**
     * set slider_title method is stand for set the value of slider_title.
     *
     * @var varchar slider_title
     */
    public function set_slider_title($value)
    {
        $this->_slider_title = $value;
    }

    /**
     * get slider_image method is stand for get the value of slider_image.
     *
     * @var varchar slider_image
     */
    public function get_slider_image()
    {
        return $this->_slider_image;
    }

    /**
     * set slider_image method is stand for set the value of slider_image.
     *
     * @var varchar slider_image
     */
    public function set_slider_image($value)
    {
        $this->_slider_image = $value;
    }

    /**
     * get slider_status method is stand for get the value of slider_status.
     *
     * @var varchar slider_status
     */
    public function get_slider_status()
    {
        return $this->_slider_status;
    }

    /**
     * set slider_status method is stand for set the value of slider_status.
     *
     * @var varchar slider_status
     */
    public function set_slider_status($value)
    {
        $this->_slider_status = $value;
    }

    /**
     * get slider_updated_by method is stand for get the value of slider_updated_by.
     *
     * @var int slider_updated_by
     */
    public function get_slider_updated_by()
    {
        return (int) $this->_slider_updated_by;
    }

    /**
     * set slider_updated_by method is stand for set the value of slider_updated_by.
     *
     * @var int slider_updated_by
     */
    public function set_slider_updated_by($value)
    {
        $this->_slider_updated_by = (int) $value;
    }

    /**
     * get slider_updated_date method is stand for get the value of
     * slider_updated_date.
     *
     * @var timestamp slider_updated_date
     */
    public function get_slider_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_slider_updated_date));
    }

    /**
     * set slider_updated_date method is stand for set the value of
     * slider_updated_date.
     *
     * @var timestamp slider_updated_date
     */
    public function set_slider_updated_date($value)
    {
        $this->_slider_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get slider_created_by method is stand for get the value of slider_created_by.
     *
     * @var int slider_created_by
     */
    public function get_slider_created_by()
    {
        return (int) $this->_slider_created_by;
    }

    /**
     * set slider_created_by method is stand for set the value of slider_created_by.
     *
     * @var int slider_created_by
     */
    public function set_slider_created_by($value)
    {
        $this->_slider_created_by = (int) $value;
    }

    /**
     * get slider_created_date method is stand for get the value of
     * slider_created_date.
     *
     * @var timestamp slider_created_date
     */
    public function get_slider_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_slider_created_date));
    }

    /**
     * set slider_created_date method is stand for set the value of
     * slider_created_date.
     *
     * @var timestamp slider_created_date
     */
    public function set_slider_created_date($value)
    {
        $this->_slider_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_slider by set id thru constructor.
     *
     * @var int id
     * @var varchar slider_title
     * @var varchar slider_image
     * @var varchar slider_status
     * @var int slider_updated_by
     * @var timestamp slider_updated_date
     * @var int slider_created_by
     * @var timestamp slider_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_slider_title($row->slider_title);
          $this->set_slider_image($row->slider_image);
          $this->set_slider_status($row->slider_status);
          $this->set_slider_updated_by($row->slider_updated_by);
          $this->set_slider_updated_date($row->slider_updated_date);
          $this->set_slider_created_by($row->slider_created_by);
          $this->set_slider_created_date($row->slider_created_date);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var varchar slider_title
     * @var varchar slider_image
     * @var varchar slider_status
     * @var int slider_updated_by
     * @var int slider_created_by
     */
    public function save()
    {
        $data = array(
          "slider_title" => $this->get_slider_title(),
          "slider_image" => $this->get_slider_image(),
          "slider_status" => $this->get_slider_status(),
          "slider_updated_by" => $this->get_slider_updated_by(),
          "slider_created_by" => $this->get_slider_created_by());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from asit_slider by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_slider_title_by_id method is stand for get the value ofslider_title By id.
     *
     * @var varchar slider_title
     */
    public function get_slider_title_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_slider_title();
    }

    /**
     * get_slider_image_by_id method is stand for get the value ofslider_image By id.
     *
     * @var varchar slider_image
     */
    public function get_slider_image_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_slider_image();
    }

    /**
     * get_slider_status_by_id method is stand for get the value ofslider_status By id.
     *
     * @var varchar slider_status
     */
    public function get_slider_status_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_slider_status();
    }

    /**
     * get_slider_updated_by_by_id method is stand for get the value
     * ofslider_updated_by By id.
     *
     * @var int slider_updated_by
     */
    public function get_slider_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_slider_updated_by();
    }

    /**
     * get_slider_updated_date_by_id method is stand for get the value
     * ofslider_updated_date By id.
     *
     * @var timestamp slider_updated_date
     */
    public function get_slider_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_slider_updated_date()));
    }

    /**
     * get_slider_created_by_by_id method is stand for get the value
     * ofslider_created_by By id.
     *
     * @var int slider_created_by
     */
    public function get_slider_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_slider_created_by();
    }

    /**
     * get_slider_created_date_by_id method is stand for get the value
     * ofslider_created_date By id.
     *
     * @var timestamp slider_created_date
     */
    public function get_slider_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_slider_created_date()));
    }


}
