<?php

class Application_Model_SliderLogic extends Application_Model_Slider
{
    
    public function fetchOrdered()
    {
        return $this->fetchAll($this->select()->where('slider_status = ?', 'A')->order('slider_title'));
    }
    
    public function fetchDataTableSelect() 
    {
        $columns = array('slider_image', 'slider_title', 'slider_status', 'action');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_SliderLogic(-1)), $columns);
        $where = $obj_data->get_where();
        $where->where('slider_status != ?', 'D');
        $obj_data->set_where($where);
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        $url = new Zend_View_Helper_Url();
        $baseUrl = new Zend_View_Helper_BaseUrl();
        $enc = new Application_Model_Util_Encrypt();
        foreach($rows as $row)
        {
            $action = '';
            if(Application_Model_RolePermissionLogic::isPermitted("Slider:Edit")) {
                $action = '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"slider", "action"=>"edit", "id"=>$enc->hideContent($row->id))).'"><input type="button" value="Edit" class="btn btn-info" /></a> ';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("Slider:Delete")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"slider", "action"=>"delete", "id"=>$enc->hideContent($row->id))).'"><input type="button" value="Delete" class="btn btn-danger" /></a>';
            }
            $results[$i] = array('<img src="'.$baseUrl->baseUrl(Application_Model_Cache_Config::getConfig('UPLOAD_FOLDER_NAME').'/'.Application_Model_Cache_Config::getConfig('SLIDER_FOLDER').'/'.$row->slider_image).'" width="100" />', $row->slider_title, ($row->slider_status == 'A') ? 'Active' : 'Block', $action);
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }
}

