<?php

class Application_Model_Tag extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_intro_tags';

    private $_id = null;

    private $_tag_title = null;

    private $_tag_status = null;

    private $_tag_updated_by = null;

    private $_tag_updated_date = null;

    private $_tag_created_by = null;

    private $_tag_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get tag_title method is stand for get the value of tag_title.
     *
     * @var varchar tag_title
     */
    public function get_tag_title()
    {
        return $this->_tag_title;
    }

    /**
     * set tag_title method is stand for set the value of tag_title.
     *
     * @var varchar tag_title
     */
    public function set_tag_title($value)
    {
        $this->_tag_title = $value;
    }

    /**
     * get tag_status method is stand for get the value of tag_status.
     *
     * @var varchar tag_status
     */
    public function get_tag_status()
    {
        return $this->_tag_status;
    }

    /**
     * set tag_status method is stand for set the value of tag_status.
     *
     * @var varchar tag_status
     */
    public function set_tag_status($value)
    {
        $this->_tag_status = $value;
    }

    /**
     * get tag_updated_by method is stand for get the value of tag_updated_by.
     *
     * @var int tag_updated_by
     */
    public function get_tag_updated_by()
    {
        return (int) $this->_tag_updated_by;
    }

    /**
     * set tag_updated_by method is stand for set the value of tag_updated_by.
     *
     * @var int tag_updated_by
     */
    public function set_tag_updated_by($value)
    {
        $this->_tag_updated_by = (int) $value;
    }

    /**
     * get tag_updated_date method is stand for get the value of tag_updated_date.
     *
     * @var timestamp tag_updated_date
     */
    public function get_tag_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_tag_updated_date));
    }

    /**
     * set tag_updated_date method is stand for set the value of tag_updated_date.
     *
     * @var timestamp tag_updated_date
     */
    public function set_tag_updated_date($value)
    {
        $this->_tag_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get tag_created_by method is stand for get the value of tag_created_by.
     *
     * @var int tag_created_by
     */
    public function get_tag_created_by()
    {
        return (int) $this->_tag_created_by;
    }

    /**
     * set tag_created_by method is stand for set the value of tag_created_by.
     *
     * @var int tag_created_by
     */
    public function set_tag_created_by($value)
    {
        $this->_tag_created_by = (int) $value;
    }

    /**
     * get tag_created_date method is stand for get the value of tag_created_date.
     *
     * @var timestamp tag_created_date
     */
    public function get_tag_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_tag_created_date));
    }

    /**
     * set tag_created_date method is stand for set the value of tag_created_date.
     *
     * @var timestamp tag_created_date
     */
    public function set_tag_created_date($value)
    {
        $this->_tag_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_intro_tags by set id thru constructor.
     *
     * @var int id
     * @var varchar tag_title
     * @var varchar tag_status
     * @var int tag_updated_by
     * @var timestamp tag_updated_date
     * @var int tag_created_by
     * @var timestamp tag_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_tag_title($row->tag_title);
          $this->set_tag_status($row->tag_status);
          $this->set_tag_updated_by($row->tag_updated_by);
          $this->set_tag_updated_date($row->tag_updated_date);
          $this->set_tag_created_by($row->tag_created_by);
          $this->set_tag_created_date($row->tag_created_date);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var varchar tag_title
     * @var varchar tag_status
     * @var int tag_updated_by
     * @var int tag_created_by
     */
    public function save()
    {
        $data = array(
          "tag_title" => $this->get_tag_title(),
          "tag_status" => $this->get_tag_status(),
          "tag_updated_by" => $this->get_tag_updated_by(),
          "tag_created_by" => $this->get_tag_created_by());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from asit_intro_tags by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_tag_title_by_id method is stand for get the value oftag_title By id.
     *
     * @var varchar tag_title
     */
    public function get_tag_title_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_tag_title();
    }

    /**
     * get_tag_status_by_id method is stand for get the value oftag_status By id.
     *
     * @var varchar tag_status
     */
    public function get_tag_status_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_tag_status();
    }

    /**
     * get_tag_updated_by_by_id method is stand for get the value oftag_updated_by By
     * id.
     *
     * @var int tag_updated_by
     */
    public function get_tag_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_tag_updated_by();
    }

    /**
     * get_tag_updated_date_by_id method is stand for get the value oftag_updated_date
     * By id.
     *
     * @var timestamp tag_updated_date
     */
    public function get_tag_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_tag_updated_date()));
    }

    /**
     * get_tag_created_by_by_id method is stand for get the value oftag_created_by By
     * id.
     *
     * @var int tag_created_by
     */
    public function get_tag_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_tag_created_by();
    }

    /**
     * get_tag_created_date_by_id method is stand for get the value oftag_created_date
     * By id.
     *
     * @var timestamp tag_created_date
     */
    public function get_tag_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_tag_created_date()));
    }


}
