<?php

class Application_Model_TagLogic extends Application_Model_Tag
{
    
    public function fetchOrdered()
    {
        return $this->fetchAll($this->select()->where('tag_status = ?', 'A')->order('tag_title'));
    }
    
    public function fetchDataTableSelect() 
    {
        $columns = array('tag_title', 'action');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_TagLogic(-1)), $columns);
        $where = $obj_data->get_where();
        $where->where('tag_status = ?', 'A');
        $obj_data->set_where($where);
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        $url = new Zend_View_Helper_Url();
        $enc = new Application_Model_Util_Encrypt();
        foreach($rows as $row)
        {
            $action = '';
            if(Application_Model_RolePermissionLogic::isPermitted("Tag:Edit")) {
                $action = '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"tag", "action"=>"edit", "id"=>$enc->hideContent($row->id))).'"><input type="button" value="Edit" class="btn btn-info" /></a> ';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("Tag:Delete")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"tag", "action"=>"delete", "id"=>$enc->hideContent($row->id))).'"><input type="button" value="Delete" class="btn btn-danger" /></a>';
            }
            $results[$i] = array($row->tag_title, $action);
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }
}

