<?php

class Application_Model_Tc extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_tc';

    private $_id = null;

    private $_tc_student = null;

    private $_tc_file = null;

    private $_tc_download = null;

    private $_tc_status = null;

    private $_tc_updated_by = null;

    private $_tc_updated_date = null;

    private $_tc_created_by = null;

    private $_tc_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get tc_student method is stand for get the value of tc_student.
     *
     * @var varchar tc_student
     */
    public function get_tc_student()
    {
        return $this->_tc_student;
    }

    /**
     * set tc_student method is stand for set the value of tc_student.
     *
     * @var varchar tc_student
     */
    public function set_tc_student($value)
    {
        $this->_tc_student = $value;
    }

    /**
     * get tc_file method is stand for get the value of tc_file.
     *
     * @var varchar tc_file
     */
    public function get_tc_file()
    {
        return $this->_tc_file;
    }

    /**
     * set tc_file method is stand for set the value of tc_file.
     *
     * @var varchar tc_file
     */
    public function set_tc_file($value)
    {
        $this->_tc_file = $value;
    }

    /**
     * get tc_download method is stand for get the value of tc_download.
     *
     * @var smallint tc_download
     */
    public function get_tc_download()
    {
        return $this->_tc_download;
    }

    /**
     * set tc_download method is stand for set the value of tc_download.
     *
     * @var smallint tc_download
     */
    public function set_tc_download($value)
    {
        $this->_tc_download = $value;
    }

    /**
     * get tc_status method is stand for get the value of tc_status.
     *
     * @var varchar tc_status
     */
    public function get_tc_status()
    {
        return $this->_tc_status;
    }

    /**
     * set tc_status method is stand for set the value of tc_status.
     *
     * @var varchar tc_status
     */
    public function set_tc_status($value)
    {
        $this->_tc_status = $value;
    }

    /**
     * get tc_updated_by method is stand for get the value of tc_updated_by.
     *
     * @var int tc_updated_by
     */
    public function get_tc_updated_by()
    {
        return (int) $this->_tc_updated_by;
    }

    /**
     * set tc_updated_by method is stand for set the value of tc_updated_by.
     *
     * @var int tc_updated_by
     */
    public function set_tc_updated_by($value)
    {
        $this->_tc_updated_by = (int) $value;
    }

    /**
     * get tc_updated_date method is stand for get the value of tc_updated_date.
     *
     * @var timestamp tc_updated_date
     */
    public function get_tc_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_tc_updated_date));
    }

    /**
     * set tc_updated_date method is stand for set the value of tc_updated_date.
     *
     * @var timestamp tc_updated_date
     */
    public function set_tc_updated_date($value)
    {
        $this->_tc_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get tc_created_by method is stand for get the value of tc_created_by.
     *
     * @var int tc_created_by
     */
    public function get_tc_created_by()
    {
        return (int) $this->_tc_created_by;
    }

    /**
     * set tc_created_by method is stand for set the value of tc_created_by.
     *
     * @var int tc_created_by
     */
    public function set_tc_created_by($value)
    {
        $this->_tc_created_by = (int) $value;
    }

    /**
     * get tc_created_date method is stand for get the value of tc_created_date.
     *
     * @var timestamp tc_created_date
     */
    public function get_tc_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_tc_created_date));
    }

    /**
     * set tc_created_date method is stand for set the value of tc_created_date.
     *
     * @var timestamp tc_created_date
     */
    public function set_tc_created_date($value)
    {
        $this->_tc_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_tc by set id thru constructor.
     *
     * @var int id
     * @var varchar tc_student
     * @var varchar tc_file
     * @var smallint tc_download
     * @var varchar tc_status
     * @var int tc_updated_by
     * @var timestamp tc_updated_date
     * @var int tc_created_by
     * @var timestamp tc_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_tc_student($row->tc_student);
          $this->set_tc_file($row->tc_file);
          $this->set_tc_download($row->tc_download);
          $this->set_tc_status($row->tc_status);
          $this->set_tc_updated_by($row->tc_updated_by);
          $this->set_tc_updated_date($row->tc_updated_date);
          $this->set_tc_created_by($row->tc_created_by);
          $this->set_tc_created_date($row->tc_created_date);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var varchar tc_student
     * @var varchar tc_file
     * @var smallint tc_download
     * @var varchar tc_status
     * @var int tc_updated_by
     * @var int tc_created_by
     */
    public function save()
    {
        $data = array(
          "tc_student" => $this->get_tc_student(),
          "tc_file" => $this->get_tc_file(),
          "tc_download" => $this->get_tc_download(),
          "tc_status" => $this->get_tc_status(),
          "tc_updated_by" => $this->get_tc_updated_by(),
          "tc_created_by" => $this->get_tc_created_by());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from asit_tc by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_tc_student_by_id method is stand for get the value oftc_student By id.
     *
     * @var varchar tc_student
     */
    public function get_tc_student_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_tc_student();
    }

    /**
     * get_tc_file_by_id method is stand for get the value oftc_file By id.
     *
     * @var varchar tc_file
     */
    public function get_tc_file_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_tc_file();
    }

    /**
     * get_tc_download_by_id method is stand for get the value oftc_download By id.
     *
     * @var smallint tc_download
     */
    public function get_tc_download_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_tc_download();
    }

    /**
     * get_tc_status_by_id method is stand for get the value oftc_status By id.
     *
     * @var varchar tc_status
     */
    public function get_tc_status_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_tc_status();
    }

    /**
     * get_tc_updated_by_by_id method is stand for get the value oftc_updated_by By id.
     *
     * @var int tc_updated_by
     */
    public function get_tc_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_tc_updated_by();
    }

    /**
     * get_tc_updated_date_by_id method is stand for get the value oftc_updated_date By
     * id.
     *
     * @var timestamp tc_updated_date
     */
    public function get_tc_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_tc_updated_date()));
    }

    /**
     * get_tc_created_by_by_id method is stand for get the value oftc_created_by By id.
     *
     * @var int tc_created_by
     */
    public function get_tc_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_tc_created_by();
    }

    /**
     * get_tc_created_date_by_id method is stand for get the value oftc_created_date By
     * id.
     *
     * @var timestamp tc_created_date
     */
    public function get_tc_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_tc_created_date()));
    }


}
