<?php

class Application_Model_TcLogic extends Application_Model_Tc
{
    
    public function fetchOrdered()
    {
        return $this->fetchAll($this->select()->where('tc_status = ?', 'A')->order('tc_student'));
    }
    
    public function fetchDataTableSelect() 
    {
        $columns = array('tc_student', 'tc_download', 'action');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_TcLogic(-1)), $columns);
        $where = $obj_data->get_where();
        $where->where('tc_status = ?', 'A');
        $obj_data->set_where($where);
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        $url = new Zend_View_Helper_Url();
        $enc = new Application_Model_Util_Encrypt();
        foreach($rows as $row)
        {
            $action = '';
            if(Application_Model_RolePermissionLogic::isPermitted("Tc:Edit")) {
                $action = '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"tc", "action"=>"edit", "id"=>$enc->hideContent($row->id))).'"><input type="button" value="Edit" class="btn btn-info" /></a> ';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("Tc:Edit")) {
                $action .= '<a href="#"><input type="button" value="Download" class="btn btn-info" /></a> ';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("Tag:Delete")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"tc", "action"=>"delete", "id"=>$enc->hideContent($row->id))).'"><input type="button" value="Delete" class="btn btn-danger" /></a>';
            }
            $results[$i] = array($row->tc_student, $row->tc_download, $action);
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }
    
    public function getStudentTc($sId) {
        $where = $this->select()->where('tc_student = ?', $sId)->where('tc_status = ?', 'A');
        $results = $this->fetchAll($where);
        return (count($results) > 0) ? $results[0] : null;
    }
}

