<?php

class Application_Model_Todo extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_todo';

    private $_id = null;

    private $_todo_title = null;

    private $_todo_description = null;

    private $_todo_from_date = null;

    private $_todo_to_date = null;

    private $_todo_role = null;

    private $_todo_status = null;

    private $_todo_updated_by = null;

    private $_todo_updated_date = null;

    private $_todo_created_by = null;

    private $_todo_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get todo_title method is stand for get the value of todo_title.
     *
     * @var varchar todo_title
     */
    public function get_todo_title()
    {
        return $this->_todo_title;
    }

    /**
     * set todo_title method is stand for set the value of todo_title.
     *
     * @var varchar todo_title
     */
    public function set_todo_title($value)
    {
        $this->_todo_title = $value;
    }

    /**
     * get todo_description method is stand for get the value of todo_description.
     *
     * @var varchar todo_description
     */
    public function get_todo_description()
    {
        return $this->_todo_description;
    }

    /**
     * set todo_description method is stand for set the value of todo_description.
     *
     * @var varchar todo_description
     */
    public function set_todo_description($value)
    {
        $this->_todo_description = $value;
    }

    /**
     * get todo_from_date method is stand for get the value of todo_from_date.
     *
     * @var date todo_from_date
     */
    public function get_todo_from_date()
    {
        return date("d-M-Y", strtotime($this->_todo_from_date));
    }

    /**
     * set todo_from_date method is stand for set the value of todo_from_date.
     *
     * @var date todo_from_date
     */
    public function set_todo_from_date($value)
    {
        $this->_todo_from_date = date("Y-m-d", strtotime($value));
    }

    /**
     * get todo_to_date method is stand for get the value of todo_to_date.
     *
     * @var date todo_to_date
     */
    public function get_todo_to_date()
    {
        return date("d-M-Y", strtotime($this->_todo_to_date));
    }

    /**
     * set todo_to_date method is stand for set the value of todo_to_date.
     *
     * @var date todo_to_date
     */
    public function set_todo_to_date($value)
    {
        $this->_todo_to_date = date("Y-m-d", strtotime($value));
    }

    /**
     * get todo_role method is stand for get the value of todo_role.
     *
     * @var int todo_role
     */
    public function get_todo_role()
    {
        return (int) $this->_todo_role;
    }

    /**
     * set todo_role method is stand for set the value of todo_role.
     *
     * @var int todo_role
     */
    public function set_todo_role($value)
    {
        $this->_todo_role = (int) $value;
    }

    /**
     * get todo_status method is stand for get the value of todo_status.
     *
     * @var varchar todo_status
     */
    public function get_todo_status()
    {
        return $this->_todo_status;
    }

    /**
     * set todo_status method is stand for set the value of todo_status.
     *
     * @var varchar todo_status
     */
    public function set_todo_status($value)
    {
        $this->_todo_status = $value;
    }

    /**
     * get todo_updated_by method is stand for get the value of todo_updated_by.
     *
     * @var int todo_updated_by
     */
    public function get_todo_updated_by()
    {
        return (int) $this->_todo_updated_by;
    }

    /**
     * set todo_updated_by method is stand for set the value of todo_updated_by.
     *
     * @var int todo_updated_by
     */
    public function set_todo_updated_by($value)
    {
        $this->_todo_updated_by = (int) $value;
    }

    /**
     * get todo_updated_date method is stand for get the value of todo_updated_date.
     *
     * @var timestamp todo_updated_date
     */
    public function get_todo_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_todo_updated_date));
    }

    /**
     * set todo_updated_date method is stand for set the value of todo_updated_date.
     *
     * @var timestamp todo_updated_date
     */
    public function set_todo_updated_date($value)
    {
        $this->_todo_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get todo_created_by method is stand for get the value of todo_created_by.
     *
     * @var int todo_created_by
     */
    public function get_todo_created_by()
    {
        return (int) $this->_todo_created_by;
    }

    /**
     * set todo_created_by method is stand for set the value of todo_created_by.
     *
     * @var int todo_created_by
     */
    public function set_todo_created_by($value)
    {
        $this->_todo_created_by = (int) $value;
    }

    /**
     * get todo_created_date method is stand for get the value of todo_created_date.
     *
     * @var timestamp todo_created_date
     */
    public function get_todo_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_todo_created_date));
    }

    /**
     * set todo_created_date method is stand for set the value of todo_created_date.
     *
     * @var timestamp todo_created_date
     */
    public function set_todo_created_date($value)
    {
        $this->_todo_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_todo by set id thru constructor.
     *
     * @var int id
     * @var varchar todo_title
     * @var varchar todo_description
     * @var date todo_from_date
     * @var date todo_to_date
     * @var int todo_role
     * @var varchar todo_status
     * @var int todo_updated_by
     * @var timestamp todo_updated_date
     * @var int todo_created_by
     * @var timestamp todo_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_todo_title($row->todo_title);
          $this->set_todo_description($row->todo_description);
          $this->set_todo_from_date($row->todo_from_date);
          $this->set_todo_to_date($row->todo_to_date);
          $this->set_todo_role($row->todo_role);
          $this->set_todo_status($row->todo_status);
          $this->set_todo_updated_by($row->todo_updated_by);
          $this->set_todo_updated_date($row->todo_updated_date);
          $this->set_todo_created_by($row->todo_created_by);
          $this->set_todo_created_date($row->todo_created_date);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var varchar todo_title
     * @var varchar todo_description
     * @var date todo_from_date
     * @var date todo_to_date
     * @var int todo_role
     * @var varchar todo_status
     * @var int todo_updated_by
     * @var int todo_created_by
     */
    public function save()
    {
        $data = array(
          "todo_title" => $this->get_todo_title(),
          "todo_description" => $this->get_todo_description(),
          "todo_from_date" => date("Y-m-d", strtotime($this->get_todo_from_date())),
          "todo_to_date" => date("Y-m-d", strtotime($this->get_todo_to_date())),
          "todo_role" => $this->get_todo_role(),
          "todo_status" => $this->get_todo_status(),
          "todo_updated_by" => $this->get_todo_updated_by(),
          "todo_created_by" => $this->get_todo_created_by());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from asit_todo by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_todo_title_by_id method is stand for get the value oftodo_title By id.
     *
     * @var varchar todo_title
     */
    public function get_todo_title_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_todo_title();
    }

    /**
     * get_todo_description_by_id method is stand for get the value oftodo_description
     * By id.
     *
     * @var varchar todo_description
     */
    public function get_todo_description_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_todo_description();
    }

    /**
     * get_todo_from_date_by_id method is stand for get the value oftodo_from_date By
     * id.
     *
     * @var date todo_from_date
     */
    public function get_todo_from_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y", strtotime($this->get_todo_from_date()));
    }

    /**
     * get_todo_to_date_by_id method is stand for get the value oftodo_to_date By id.
     *
     * @var date todo_to_date
     */
    public function get_todo_to_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y", strtotime($this->get_todo_to_date()));
    }

    /**
     * get_todo_role_by_id method is stand for get the value oftodo_role By id.
     *
     * @var int todo_role
     */
    public function get_todo_role_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_todo_role();
    }

    /**
     * get_todo_status_by_id method is stand for get the value oftodo_status By id.
     *
     * @var varchar todo_status
     */
    public function get_todo_status_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_todo_status();
    }

    /**
     * get_todo_updated_by_by_id method is stand for get the value oftodo_updated_by By
     * id.
     *
     * @var int todo_updated_by
     */
    public function get_todo_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_todo_updated_by();
    }

    /**
     * get_todo_updated_date_by_id method is stand for get the value
     * oftodo_updated_date By id.
     *
     * @var timestamp todo_updated_date
     */
    public function get_todo_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_todo_updated_date()));
    }

    /**
     * get_todo_created_by_by_id method is stand for get the value oftodo_created_by By
     * id.
     *
     * @var int todo_created_by
     */
    public function get_todo_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_todo_created_by();
    }

    /**
     * get_todo_created_date_by_id method is stand for get the value
     * oftodo_created_date By id.
     *
     * @var timestamp todo_created_date
     */
    public function get_todo_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_todo_created_date()));
    }


}
