<?php

class Application_Model_TodoLogic extends Application_Model_Todo
{

    public function fetchDataTableSelect() 
    {
        $columns = array('todo_title', 'todo_description', 'todo_from_date', 'todo_to_date', 'action');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_TodoLogic(-1)), $columns);
        $where = $obj_data->get_where();
        $user = new Application_Model_UserLogic(-1);
        $where->where('todo_created_by = ?', $user->getLoggedInUserId());
        $obj_data->set_where($where);
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        $url = new Zend_View_Helper_Url();
        foreach($rows as $row)
        {
            $action = '';
            if(Application_Model_RolePermissionLogic::isPermitted("Todo:Edit")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"todo", "action"=>"edit", "id"=>$row->id)).'"><input type="button" value="Edit" class="btn btn-info" /></a>';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("Todo:Delete")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"todo", "action"=>"delete", "id"=>$row->id)).'"><input type="button" value="Delete" class="btn btn-danger" /></a>';
            }
            $results[$i] = array($row->todo_title, $row->todo_description, date('d-M-Y', strtotime($row->todo_from_date)), date('d-M-Y', strtotime($row->todo_to_date)), $action);
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }
    
    public function getActiveTodosByUser($user, $start, $end)
    {
        $where = $this->select()->where('todo_created_by = ?', $user)->where('todo_status = ?', 'A')->where('todo_from_date <= ?', $end)->where('todo_to_date >= ?', $start);
        return $this->fetchAll($where);
    }

}

