<?php

class Application_Model_Topper extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_toppers';

    private $_id = null;

    private $_topper_name = null;

    private $_topper_class = null;

    private $_topper_percent = null;

    private $_topper_status = null;

    private $_topper_updated_by = null;

    private $_topper_updated_date = null;

    private $_topper_created_by = null;

    private $_topper_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get topper_name method is stand for get the value of topper_name.
     *
     * @var varchar topper_name
     */
    public function get_topper_name()
    {
        return $this->_topper_name;
    }

    /**
     * set topper_name method is stand for set the value of topper_name.
     *
     * @var varchar topper_name
     */
    public function set_topper_name($value)
    {
        $this->_topper_name = $value;
    }

    /**
     * get topper_class method is stand for get the value of topper_class.
     *
     * @var varchar topper_class
     */
    public function get_topper_class()
    {
        return $this->_topper_class;
    }

    /**
     * set topper_class method is stand for set the value of topper_class.
     *
     * @var varchar topper_class
     */
    public function set_topper_class($value)
    {
        $this->_topper_class = $value;
    }

    /**
     * get topper_percent method is stand for get the value of topper_percent.
     *
     * @var float topper_percent
     */
    public function get_topper_percent()
    {
        return $this->_topper_percent;
    }

    /**
     * set topper_percent method is stand for set the value of topper_percent.
     *
     * @var float topper_percent
     */
    public function set_topper_percent($value)
    {
        $this->_topper_percent = $value;
    }

    /**
     * get topper_status method is stand for get the value of topper_status.
     *
     * @var varchar topper_status
     */
    public function get_topper_status()
    {
        return $this->_topper_status;
    }

    /**
     * set topper_status method is stand for set the value of topper_status.
     *
     * @var varchar topper_status
     */
    public function set_topper_status($value)
    {
        $this->_topper_status = $value;
    }

    /**
     * get topper_updated_by method is stand for get the value of topper_updated_by.
     *
     * @var int topper_updated_by
     */
    public function get_topper_updated_by()
    {
        return (int) $this->_topper_updated_by;
    }

    /**
     * set topper_updated_by method is stand for set the value of topper_updated_by.
     *
     * @var int topper_updated_by
     */
    public function set_topper_updated_by($value)
    {
        $this->_topper_updated_by = (int) $value;
    }

    /**
     * get topper_updated_date method is stand for get the value of
     * topper_updated_date.
     *
     * @var timestamp topper_updated_date
     */
    public function get_topper_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_topper_updated_date));
    }

    /**
     * set topper_updated_date method is stand for set the value of
     * topper_updated_date.
     *
     * @var timestamp topper_updated_date
     */
    public function set_topper_updated_date($value)
    {
        $this->_topper_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get topper_created_by method is stand for get the value of topper_created_by.
     *
     * @var int topper_created_by
     */
    public function get_topper_created_by()
    {
        return (int) $this->_topper_created_by;
    }

    /**
     * set topper_created_by method is stand for set the value of topper_created_by.
     *
     * @var int topper_created_by
     */
    public function set_topper_created_by($value)
    {
        $this->_topper_created_by = (int) $value;
    }

    /**
     * get topper_created_date method is stand for get the value of
     * topper_created_date.
     *
     * @var timestamp topper_created_date
     */
    public function get_topper_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_topper_created_date));
    }

    /**
     * set topper_created_date method is stand for set the value of
     * topper_created_date.
     *
     * @var timestamp topper_created_date
     */
    public function set_topper_created_date($value)
    {
        $this->_topper_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_toppers by set id thru constructor.
     *
     * @var int id
     * @var varchar topper_name
     * @var varchar topper_class
     * @var float topper_percent
     * @var varchar topper_status
     * @var int topper_updated_by
     * @var timestamp topper_updated_date
     * @var int topper_created_by
     * @var timestamp topper_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_topper_name($row->topper_name);
          $this->set_topper_class($row->topper_class);
          $this->set_topper_percent($row->topper_percent);
          $this->set_topper_status($row->topper_status);
          $this->set_topper_updated_by($row->topper_updated_by);
          $this->set_topper_updated_date($row->topper_updated_date);
          $this->set_topper_created_by($row->topper_created_by);
          $this->set_topper_created_date($row->topper_created_date);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var varchar topper_name
     * @var varchar topper_class
     * @var float topper_percent
     * @var varchar topper_status
     * @var int topper_updated_by
     * @var int topper_created_by
     */
    public function save()
    {
        $data = array(
          "topper_name" => $this->get_topper_name(),
          "topper_class" => $this->get_topper_class(),
          "topper_percent" => $this->get_topper_percent(),
          "topper_status" => $this->get_topper_status(),
          "topper_updated_by" => $this->get_topper_updated_by(),
          "topper_created_by" => $this->get_topper_created_by());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from asit_toppers by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_topper_name_by_id method is stand for get the value oftopper_name By id.
     *
     * @var varchar topper_name
     */
    public function get_topper_name_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_topper_name();
    }

    /**
     * get_topper_class_by_id method is stand for get the value oftopper_class By id.
     *
     * @var varchar topper_class
     */
    public function get_topper_class_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_topper_class();
    }

    /**
     * get_topper_percent_by_id method is stand for get the value oftopper_percent By
     * id.
     *
     * @var float topper_percent
     */
    public function get_topper_percent_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_topper_percent();
    }

    /**
     * get_topper_status_by_id method is stand for get the value oftopper_status By id.
     *
     * @var varchar topper_status
     */
    public function get_topper_status_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_topper_status();
    }

    /**
     * get_topper_updated_by_by_id method is stand for get the value
     * oftopper_updated_by By id.
     *
     * @var int topper_updated_by
     */
    public function get_topper_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_topper_updated_by();
    }

    /**
     * get_topper_updated_date_by_id method is stand for get the value
     * oftopper_updated_date By id.
     *
     * @var timestamp topper_updated_date
     */
    public function get_topper_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_topper_updated_date()));
    }

    /**
     * get_topper_created_by_by_id method is stand for get the value
     * oftopper_created_by By id.
     *
     * @var int topper_created_by
     */
    public function get_topper_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_topper_created_by();
    }

    /**
     * get_topper_created_date_by_id method is stand for get the value
     * oftopper_created_date By id.
     *
     * @var timestamp topper_created_date
     */
    public function get_topper_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_topper_created_date()));
    }


}
