<?php

class Application_Model_TopperLogic extends Application_Model_Topper
{
    
    public function fetchOrdered()
    {
        return $this->fetchAll($this->select()->where('topper_status = ?', 'A')->order('topper_name'));
    }
    
    public function fetchDataTableSelect() 
    {
        $columns = array('topper_name', 'topper_class', 'topper_percent', 'action');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_TopperLogic(-1)), $columns);
        $where = $obj_data->get_where();
        $where->where('topper_status = ?', 'A');
        $obj_data->set_where($where);
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        $url = new Zend_View_Helper_Url();
        $enc = new Application_Model_Util_Encrypt();
        foreach($rows as $row)
        {
            $action = '';
            if(Application_Model_RolePermissionLogic::isPermitted("Topper:Edit")) {
                $action = '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"topper", "action"=>"edit", "id"=>$enc->hideContent($row->id))).'"><input type="button" value="Edit" class="btn btn-info" /></a> ';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("Topper:Delete")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"topper", "action"=>"delete", "id"=>$enc->hideContent($row->id))).'"><input type="button" value="Delete" class="btn btn-danger" /></a>';
            }
            $results[$i] = array($row->topper_name, $row->topper_class, $row->topper_percent.'%', $action);
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }
}

