<?php

class Application_Model_User extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_user';

    private $_id = null;

    private $_user_id = null;

    private $_user_password = null;

    private $_user_name = null;

    private $_user_email = null;

    private $_user_mobile = null;

    private $_user_dob = null;

    private $_user_gender = null;

    private $_user_role = null;

    private $_user_status = null;

    private $_user_token = null;

    private $_user_updated_by = null;

    private $_user_updated_date = null;

    private $_user_created_by = null;

    private $_user_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get user_id method is stand for get the value of user_id.
     *
     * @var varchar user_id
     */
    public function get_user_id()
    {
        return $this->_user_id;
    }

    /**
     * set user_id method is stand for set the value of user_id.
     *
     * @var varchar user_id
     */
    public function set_user_id($value)
    {
        $this->_user_id = $value;
    }

    /**
     * get user_password method is stand for get the value of user_password.
     *
     * @var varchar user_password
     */
    public function get_user_password()
    {
        return $this->_user_password;
    }

    /**
     * set user_password method is stand for set the value of user_password.
     *
     * @var varchar user_password
     */
    public function set_user_password($value)
    {
        $this->_user_password = $value;
    }

    /**
     * get user_name method is stand for get the value of user_name.
     *
     * @var varchar user_name
     */
    public function get_user_name()
    {
        return $this->_user_name;
    }

    /**
     * set user_name method is stand for set the value of user_name.
     *
     * @var varchar user_name
     */
    public function set_user_name($value)
    {
        $this->_user_name = $value;
    }

    /**
     * get user_email method is stand for get the value of user_email.
     *
     * @var varchar user_email
     */
    public function get_user_email()
    {
        return $this->_user_email;
    }

    /**
     * set user_email method is stand for set the value of user_email.
     *
     * @var varchar user_email
     */
    public function set_user_email($value)
    {
        $this->_user_email = $value;
    }

    /**
     * get user_mobile method is stand for get the value of user_mobile.
     *
     * @var varchar user_mobile
     */
    public function get_user_mobile()
    {
        return $this->_user_mobile;
    }

    /**
     * set user_mobile method is stand for set the value of user_mobile.
     *
     * @var varchar user_mobile
     */
    public function set_user_mobile($value)
    {
        $this->_user_mobile = $value;
    }

    /**
     * get user_dob method is stand for get the value of user_dob.
     *
     * @var date user_dob
     */
    public function get_user_dob()
    {
        return date(Application_Model_Cache_Config::getConfig('DEFAULT_DISPLAY_DATE_FORMAT'), strtotime($this->_user_dob));
    }

    /**
     * set user_dob method is stand for set the value of user_dob.
     *
     * @var date user_dob
     */
    public function set_user_dob($value)
    {
        $this->_user_dob = date("Y-m-d", strtotime($value));
    }

    /**
     * get user_gender method is stand for get the value of user_gender.
     *
     * @var varchar user_gender
     */
    public function get_user_gender()
    {
        return $this->_user_gender;
    }

    /**
     * set user_gender method is stand for set the value of user_gender.
     *
     * @var varchar user_gender
     */
    public function set_user_gender($value)
    {
        $this->_user_gender = $value;
    }

    /**
     * get user_role method is stand for get the value of user_role.
     *
     * @var int user_role
     */
    public function get_user_role()
    {
        return (int) $this->_user_role;
    }

    /**
     * set user_role method is stand for set the value of user_role.
     *
     * @var int user_role
     */
    public function set_user_role($value)
    {
        $this->_user_role = (int) $value;
    }

    /**
     * get user_status method is stand for get the value of user_status.
     *
     * @var varchar user_status
     */
    public function get_user_status()
    {
        return $this->_user_status;
    }

    /**
     * set user_status method is stand for set the value of user_status.
     *
     * @var varchar user_status
     */
    public function set_user_status($value)
    {
        $this->_user_status = $value;
    }

    /**
     * get user_token method is stand for get the value of user_token.
     *
     * @var varchar user_token
     */
    public function get_user_token()
    {
        return $this->_user_token;
    }

    /**
     * set user_token method is stand for set the value of user_token.
     *
     * @var varchar user_token
     */
    public function set_user_token($value)
    {
        $this->_user_token = $value;
    }

    /**
     * get user_updated_by method is stand for get the value of user_updated_by.
     *
     * @var int user_updated_by
     */
    public function get_user_updated_by()
    {
        return (int) $this->_user_updated_by;
    }

    /**
     * set user_updated_by method is stand for set the value of user_updated_by.
     *
     * @var int user_updated_by
     */
    public function set_user_updated_by($value)
    {
        $this->_user_updated_by = (int) $value;
    }

    /**
     * get user_updated_date method is stand for get the value of user_updated_date.
     *
     * @var timestamp user_updated_date
     */
    public function get_user_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_user_updated_date));
    }

    /**
     * set user_updated_date method is stand for set the value of user_updated_date.
     *
     * @var timestamp user_updated_date
     */
    public function set_user_updated_date($value)
    {
        $this->_user_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get user_created_by method is stand for get the value of user_created_by.
     *
     * @var int user_created_by
     */
    public function get_user_created_by()
    {
        return (int) $this->_user_created_by;
    }

    /**
     * set user_created_by method is stand for set the value of user_created_by.
     *
     * @var int user_created_by
     */
    public function set_user_created_by($value)
    {
        $this->_user_created_by = (int) $value;
    }

    /**
     * get user_created_date method is stand for get the value of user_created_date.
     *
     * @var timestamp user_created_date
     */
    public function get_user_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_user_created_date));
    }

    /**
     * set user_created_date method is stand for set the value of user_created_date.
     *
     * @var timestamp user_created_date
     */
    public function set_user_created_date($value)
    {
        $this->_user_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_user by set id thru constructor.
     *
     * @var int id
     * @var varchar user_id
     * @var varchar user_password
     * @var varchar user_name
     * @var varchar user_email
     * @var varchar user_mobile
     * @var date user_dob
     * @var varchar user_gender
     * @var int user_role
     * @var varchar user_status
     * @var varchar user_token
     * @var int user_updated_by
     * @var timestamp user_updated_date
     * @var int user_created_by
     * @var timestamp user_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_user_id($row->user_id);
          $this->set_user_password($row->user_password);
          $this->set_user_name($row->user_name);
          $this->set_user_email($row->user_email);
          $this->set_user_mobile($row->user_mobile);
          $this->set_user_dob($row->user_dob);
          $this->set_user_gender($row->user_gender);
          $this->set_user_role($row->user_role);
          $this->set_user_status($row->user_status);
          $this->set_user_token($row->user_token);
          $this->set_user_updated_by($row->user_updated_by);
          $this->set_user_updated_date($row->user_updated_date);
          $this->set_user_created_by($row->user_created_by);
          $this->set_user_created_date($row->user_created_date);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var varchar user_id
     * @var varchar user_password
     * @var varchar user_name
     * @var varchar user_email
     * @var varchar user_mobile
     * @var date user_dob
     * @var varchar user_gender
     * @var int user_role
     * @var varchar user_status
     * @var varchar user_token
     * @var int user_updated_by
     * @var int user_created_by
     */
    public function save()
    {
        $data = array(
          "user_id" => $this->get_user_id(),
          "user_password" => $this->get_user_password(),
          "user_name" => $this->get_user_name(),
          "user_email" => $this->get_user_email(),
          "user_mobile" => $this->get_user_mobile(),
          "user_dob" => date("Y-m-d", strtotime($this->get_user_dob())),
          "user_gender" => $this->get_user_gender(),
          "user_role" => $this->get_user_role(),
          "user_status" => $this->get_user_status(),
          "user_token" => $this->get_user_token(),
          "user_updated_by" => $this->get_user_updated_by(),
          "user_created_by" => $this->get_user_created_by());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from asit_user by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_user_id_by_id method is stand for get the value ofuser_id By id.
     *
     * @var varchar user_id
     */
    public function get_user_id_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_user_id();
    }

    /**
     * get_user_password_by_id method is stand for get the value ofuser_password By id.
     *
     * @var varchar user_password
     */
    public function get_user_password_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_user_password();
    }

    /**
     * get_user_name_by_id method is stand for get the value ofuser_name By id.
     *
     * @var varchar user_name
     */
    public function get_user_name_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_user_name();
    }

    /**
     * get_user_email_by_id method is stand for get the value ofuser_email By id.
     *
     * @var varchar user_email
     */
    public function get_user_email_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_user_email();
    }

    /**
     * get_user_mobile_by_id method is stand for get the value ofuser_mobile By id.
     *
     * @var varchar user_mobile
     */
    public function get_user_mobile_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_user_mobile();
    }

    /**
     * get_user_dob_by_id method is stand for get the value ofuser_dob By id.
     *
     * @var date user_dob
     */
    public function get_user_dob_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y", strtotime($this->get_user_dob()));
    }

    /**
     * get_user_gender_by_id method is stand for get the value ofuser_gender By id.
     *
     * @var varchar user_gender
     */
    public function get_user_gender_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_user_gender();
    }

    /**
     * get_user_role_by_id method is stand for get the value ofuser_role By id.
     *
     * @var int user_role
     */
    public function get_user_role_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_user_role();
    }

    /**
     * get_user_status_by_id method is stand for get the value ofuser_status By id.
     *
     * @var varchar user_status
     */
    public function get_user_status_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_user_status();
    }

    /**
     * get_user_token_by_id method is stand for get the value ofuser_token By id.
     *
     * @var varchar user_token
     */
    public function get_user_token_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_user_token();
    }

    /**
     * get_user_updated_by_by_id method is stand for get the value ofuser_updated_by By
     * id.
     *
     * @var int user_updated_by
     */
    public function get_user_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_user_updated_by();
    }

    /**
     * get_user_updated_date_by_id method is stand for get the value
     * ofuser_updated_date By id.
     *
     * @var timestamp user_updated_date
     */
    public function get_user_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_user_updated_date()));
    }

    /**
     * get_user_created_by_by_id method is stand for get the value ofuser_created_by By
     * id.
     *
     * @var int user_created_by
     */
    public function get_user_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_user_created_by();
    }

    /**
     * get_user_created_date_by_id method is stand for get the value
     * ofuser_created_date By id.
     *
     * @var timestamp user_created_date
     */
    public function get_user_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_user_created_date()));
    }


}
