<?php

class  Application_Model_UserLogic extends Application_Model_User
{
    
    public function checkUserIdExist($userid)
    {
        $where = $this->select()->where('user_id = ?', $userid)->where('user_status != ?', 'D');
        $count = count($this->fetchAll($where));
        return ($count > 0) ? true : false;
    }
    
    public function getUserName($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_user_name();
    }
    
    public function checkEmailExist($email)
    {
        $where = $this->select()->where('user_email = ?', $email)->where('user_status != ?', 'D');
        return (count($this->fetchAll($where)) > 0) ? true : false;
    }
    
    public function getUserByEmail($email)
    {
        $where = $this->select()->where('user_email = ?', $email);
        return $this->fetchRow($where);
    }
    
    public function getUserByUserId($userId)
    {
        $where = $this->select()->where('user_id = ?', $userId);
        $row = $this->fetchRow($where);
        $obj_user = new Application_Model_User($row['id']);
        return $obj_user;
    }
    
    public function checkMobileExist($mobile)
    {
        $where = $this->select()->where('user_mobile = ?', $mobile);
        return (count($this->fetchAll($where)) > 0) ? true : false;
    }
    
    public function getUserByMobile($mobile)
    {
        $where = $this->select()->where('user_mobile = ?', $mobile);
        return $this->fetchRow($where);
    }
    
    public function getIdByUserEmail($userEmail)
    {
        $where = $this->select()->where('user_email = ?', $userEmail);
        $result = $this->fetchRow($where);
        return $result['id'];        
    }

    public function getSaltByUserEmail($userEmail)
    {
        $where = $this->select()->where('user_id = ?', $userEmail);
        $result = $this->fetchRow($where);
        return $result['user_token'];        
    }
    
    public function is_user_authenticated($uname, $paswd) {
        $where = $this->select()
                ->where('user_id = ?', $uname)
                ->where('user_status = ?', 'A')
                ->where("user_password = ?", sha1($paswd));
        $result = $this->fetchRow($where);
        if(!empty($result)){
            Zend_Session::regenerateId();
            $auth = Zend_Auth::getInstance();
            $obj_user = new Application_Model_UserLogic($result['id']);
            $auth->getStorage()->write($obj_user);
            $sess = new Zend_Session_Namespace('user');
            $sess->id = $obj_user->get_id();
            $sess->user_id = $obj_user->get_user_id();
            $sess->user_name = $obj_user->get_user_name();
            $sess->user_email = $obj_user->get_user_email();
            $sess->user_role = $obj_user->get_user_role();
            return true;
        }else{
            return false;
        }
    }
    
    public function is_student_authenticated($uname, $paswd) {
        /*$where = $this->select()
                ->where('user_id = ?', $uname)
                ->where('user_status = ?', 'A')
                ->where("user_password = ?", sha1($paswd));
        $result = $this->fetchRow($where);
        if(!empty($result)){*/
        if($paswd == 'admin') {
            Zend_Session::regenerateId();
            $auth = Zend_Auth::getInstance();
            //$obj_user = new Application_Model_UserLogic($result['id']);
            $auth->getStorage()->write($uname);
            $sess = new Zend_Session_Namespace('user');
            //$sess->id = $obj_user->get_id();
            $sess->user_id = $uname;
            //$sess->user_name = $obj_user->get_user_name();
            //$sess->user_email = $obj_user->get_user_email();
            //$sess->user_role = $obj_user->get_user_role();
            return true;
        }else{
            return false;
        }
    }
    
    public function logout() {        
        $auth = Zend_Auth::getInstance();
        $userSess = new Zend_Session_Namespace('user');
        unset($userSess->id);
        unset($userSess->user_id);
        unset($userSess->user_name);
        unset($userSess->user_email);
        unset($userSess->user_role);
        Zend_Session::namespaceUnset('user');
        $auth->clearIdentity();
        Zend_Session::regenerateId();
    }
    
    public function isLoggedIn()
    {
        $status = false;
        $auth = Zend_Auth::getInstance();
        $userSess = new Zend_Session_Namespace('user');
        if($auth->hasIdentity() && !empty($userSess->id))
        {
            $status = true;
        } 
        return $status;
    }

    public function getLoggedInUser()
    {
        if($this->isLoggedIn()) {
            $userSess = new Zend_Session_Namespace('user');
            $obj_user = new Application_Model_User($userSess->id);
            return $obj_user;
        }else{
            return null;
        }
    }
    
    public function fetchDataTableSelect() 
    {
        $columns = array('user_id', 'user_name', 'user_gender', 'user_email', 'user_mobile', 'user_status', 'action');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_UserLogic(-1)), $columns);
        $where = $obj_data->get_where();
        $where->where('id > ?', 1)->where('user_status != ?', 'D');
        $obj_data->set_where($where);
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        $url = new Zend_View_Helper_Url();
        //Zend_Debug::dump($rows);
        foreach($rows as $row)
        {
            if(Application_Model_RolePermissionLogic::isPermitted('User:View')) {
                $action = '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"user", "action"=>"view", "id"=>$row->id)).'"><input type="button" value="View" class="btn btn-info" /></a> '; 
            }
            if(Application_Model_RolePermissionLogic::isPermitted('User:Edit')) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"user", "action"=>"edit", "id"=>$row->id)).'"><input type="button" value="Edit" class="btn btn-primary" /></a> '; 
            }
            if(Application_Model_RolePermissionLogic::isPermitted('User:Delete')) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"user", "action"=>"delete", "id"=>$row->id)).'"><input type="button" value="Delete" class="btn btn-danger" /></a> '; 
            }
            $status = Application_Model_Cache_Config::getConfig('STATUS_TYPE');
            $results[$i] = array($row->user_id, $row->user_name, $row->user_gender, $row->user_email, $row->user_mobile, $status[$row->user_status], $action);
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }
    
    public static function getLoggedInUserId()
    {
        $userSess = new Zend_Session_Namespace('user');
        return $userSess->id;
    }
    
    public function getUserIntoArray($id)
    {
        $obj_user = new Application_Model_User(-1);
        $where = $obj_user->select()
                ->where('id = ?', $id);
        $result = $this->fetchRow($where);
        return $result->toArray();
    }
    
    public function fetchOrdered()
    {
        return $this->fetchAll($this->select()->where('user_status = ?', 'A')->order('user_name'));
    }
    
    public function getClaimInitiatorUsers()
    {
        $roles = Application_Model_Cache_Config::getConfig('CLAIM_SURVEYORS_ROLE');
        $where = $this->select()->where('user_status = ?', 'A');
        $select = $this->select();
        foreach ($roles as $role) {
            $select->orWhere('user_role = ?', $role);
        }
        $where->where(implode(' ',$select->getPart(Zend_Db_Select::WHERE)));
        $where->order('user_name');
        return $this->fetchAll($where);
    }
    
    public function fetchActiveUsers()
    {
        $where = $this->select()->where('user_status = ?', 'A');
        return $this->fetchAll($where);
    }
    
    public function fetchActiveUsersByRole($role)
    {
        $where = $this->select()->where('user_status = ?', 'A')->where('user_role = ?', $role);
        return $this->fetchAll($where);
    }
    
}

