<?php

class Application_Model_Util_Cookie
{
    
    public function generateCookie($cookieName, $value, $expires = 3600, $path = '/', $domain = null, $isHttpOnly = true)
    {
        $domain = ($domain != null) ? $domain : Application_Model_Cache_Config::getConfig('SITE_URL');
        setcookie($cookieName, $value, time() + $expires, $path);
    }
    
    public function isCookieExist($cookieName)
    {
        $request = new Zend_Controller_Request_Http();
        $value = $request->getCookie($cookieName);
        return (!empty($value)) ? true : false;
    }
    
    public function getCookieValue($cookieName)
    {
        $request = new Zend_Controller_Request_Http();
        $value = $request->getCookie($cookieName);
        return $value;
    }
    
    public function destroyCookie($cookieName, $path = '/')
    {
        setcookie($cookieName, '', -1, $path);
        setcookie($cookieName, '', -1, $path);
    }
    
    public function generateUserCookie($id)
    {
        $obj_user = new Application_Model_User($id);
        $token = Application_Model_Util_Encrypt::getUniqueRandomString();
        $secureToken = hash('sha512', ($obj_user->get_user_token().$token));
        $this->generateCookie('user_id', $obj_user->get_user_email(), 60*60*24*7);
        $this->generateCookie('user_secure_token', $secureToken, 60*60*24*7);
        $obj_user->set_user_cookie($token);
        $obj_user->save();
    }

    public function destroyUserCookie()
    {
        $this->destroyCookie('user_id');
        $this->destroyCookie('user_secure_token');
    }

}

