<?php

class Application_Model_Util_Datatable
{
    private $_obj = null;
    
    private $_columns = null;
    
    private $_search = null;
    
    private $_echo = null;
    
    private $_sort = null;
    
    private $_start = null;
    
    private $_length = null;
    
    private $_where = null;
    
    private $_total_results = null;
    
    private $_filtered_results = null;
    
    public function __construct($obj, $columns)
    {
        $this->set_obj($obj);
        $this->set_columns($columns);
        $this->setupSEcho();
        $this->setupLimit();
        $this->setupSearch();
        $this->setupSort();
        $this->setupWhere();
    }

    public function fetch()
    {
        $obj = $this->get_obj();
        $columns = $this->get_columns();
        $sort = $this->get_sort();
        $start = $this->get_start();
        $length = $this->get_length();
        $search = $this->get_search();
        
        $where = $this->get_where();
        
        if($search != null) {
            $i = 0;
            $searchCondition = $this->get_obj()->select();
            foreach($columns as $column) {
                $i += 1;
                if($column != '' && $column != 'action') {
                    $searchCondition->orWhere($column.' like ?', '%'.$search.'%');
                }
            }
            $where->where(implode(' ',$searchCondition->getPart(Zend_Db_Select::WHERE)));
        }
        
        
        
        if($sort != null) {
            $order = '';
//            for($i=0; $i<count($sort); $i++) {
//                $order .= (($i != 0) ? ', ':'').$columns[$sort['col']].' '.mysql_real_escape_string($sort['dir']);
//            }
            $where->order($sort);
        }
        
        $this->set_total_results(count($obj->fetchAll($where)));
        if($this->get_start() > 0) {
            $where->limit($length, $start);
        }else {
            $where->limit($length);
        }
        $results = $obj->fetchAll($where);
        $this->set_filtered_results(count($results));
        
        return $results;
    }
    
    public function configureOutput($results)
    {
        $output = array(
            "sEcho" => (int) $this->get_echo(),
            "iTotalRecords" => (int) $this->get_total_results(),
            "iTotalDisplayRecords" => (int) $this->get_total_results(),
            "aaData" => $results
        );
        return json_encode($output);
    }
    
    public static function getRequest() {
        $front = Zend_Controller_Front::getInstance();
        return $front->getRequest();
    }

    public function setupSEcho()
    {
        $request = self::getRequest();
        $this->set_echo($request->getParam('sEcho'));
    }
    
    public function setupSearch()
    {
        $request = self::getRequest();
        $this->set_search($request->getParam('sSearch'));
    }
    
    public function setupLimit()
    {
        $request = self::getRequest();
        $this->set_start((int) $request->getParam('iDisplayStart'));
        $this->set_length($request->getParam('iDisplayLength'));
    }
    
    public function setupSort()
    {
        $request = self::getRequest();
        $sort = null;
        if ($request->getParam('iSortCol_0') != '')
        {
            $columns = $this->get_columns();
            $sort = $columns[$request->getParam('iSortCol_0')].' '.$request->getParam('sSortDir_0');
        }
        $this->set_sort($sort);
    }
    
    public function setupWhere()
    {
        $this->set_where($this->get_obj()->select());
    }
    
    public function get_obj() {
        return $this->_obj;
    }

    public function get_columns() {
        return $this->_columns;
    }

    public function get_search() {
        return $this->_search;
    }

    public function get_echo() {
        return $this->_echo;
    }

    public function get_sort() {
        return $this->_sort;
    }

    public function get_start() {
        return $this->_start;
    }

    public function get_length() {
        return $this->_length;
    }

    public function set_obj($_obj) {
        $this->_obj = $_obj;
    }

    public function set_columns($_columns) {
        $this->_columns = $_columns;
    }

    public function set_search($_search) {
        $this->_search = $_search;
    }

    public function set_echo($_echo) {
        $this->_echo = $_echo;
    }

    public function set_sort($_sort) {
        $this->_sort = $_sort;
    }

    public function set_start($_start) {
        $this->_start = $_start;
    }

    public function set_length($_length) {
        $this->_length = $_length;
    }

    public function get_where() {
        return $this->_where;
    }

    public function set_where($_where) {
        $this->_where = $_where;
    }
    
    public function get_total_results() {
        return $this->_total_results;
    }

    public function get_filtered_results() {
        return $this->_filtered_results;
    }

    public function set_total_results($_total_results) {
        $this->_total_results = $_total_results;
    }

    public function set_filtered_results($_filtered_results) {
        $this->_filtered_results = $_filtered_results;
    }



}

