<?php

class Application_Model_Util_Date
{
    
    public static function convertForDB($dateTime)
    {
        $util = new Application_Model_Util_Date();
        $date = new DateTime($dateTime, new DateTimeZone($util->getUserTimeZone()));
        $date->setTimezone(new DateTimeZone(Application_Model_Cache_Config::getConfig('DEFAULT_TIMEZONE')));
        return $date->format(Application_Model_Cache_Config::getConfig('DEFAULT_DB_FORMAT'));
    }
    
    public static function convertToDisplay($dateTime)
    {
        $date = new DateTime($dateTime);
        return $date->format(Application_Model_Cache_Config::getConfig('DEFAULT_DISPLAY_FORMAT'));
    }
    
    public static function convertToDisplayWithFormat($dateTime, $format, $timezone = null)
    {
        $util = new Application_Model_Util_Date();
        $date = new DateTime($dateTime, new DateTimeZone(Application_Model_Cache_Config::getConfig('DEFAULT_TIMEZONE')));
        if($timezone == null) {
            $date->setTimezone(new DateTimeZone($util->getUserTimeZone()));
        }else {
            $date->setTimezone(new DateTimeZone($timezone));
        }
        return $date->format($format);
    }
    
    public static function isValidTimezone($timezone) {
        return in_array($timezone, timezone_identifiers_list());
    }
    
    public static function getCurrentTime() {
        return (gmdate(Application_Model_Cache_Config::getConfig('DEFAULT_DB_FORMAT')));
    }
    
    
    public function fiscalYear($indate = null)
    {
        if($indate == null) {
            $date = new DateTime();
            $start = new DateTime();
            $start->setTime(0, 0, 0);
            $end = new DateTime();
            $end->setTime(23, 59, 59);
        }else {
            $date = new DateTime($indate);
            $start = new DateTime($indate);
            $start->setTime(0, 0, 0);
            $end = new DateTime($indate);
            $end->setTime(23, 59, 59);
        }
        $year = $date->format('Y');
        $start->setDate($year, 4, 1);
        if($start <= $date){
            $end->setDate($year +1, 3, 31);
        } else {
            $start->setDate($year - 1, 4, 1);
            $end->setDate($year, 3, 31);
        }
        $result = array();
        $result['start'] = date('Y-m-d', $start->getTimestamp());
        $result['end'] = date('Y-m-d', $end->getTimestamp());
        return $result;
    }
}

