<?php

class Application_Model_Util_Encrypt
{
    public static function getUniqueRandomString($length = -1)
    {
        if($length != -1) {
            return substr(md5(date('d-M-Y-H-i-s')), 1, $length);
        }else {
            return md5(date('d-M-Y-H-i-s'));
        }
    }
    
    public function encrypt($pure_string, $encryption_key) {
        $iv_size = mcrypt_get_iv_size(MCRYPT_BLOWFISH, MCRYPT_MODE_ECB);
        $iv = mcrypt_create_iv($iv_size, MCRYPT_RAND);
        $encrypted_string = mcrypt_encrypt(MCRYPT_BLOWFISH, $encryption_key, utf8_encode($pure_string), MCRYPT_MODE_ECB, $iv);
        return $encrypted_string;
    }

    function decrypt($encrypted_string, $encryption_key) {
        $iv_size = mcrypt_get_iv_size(MCRYPT_BLOWFISH, MCRYPT_MODE_ECB);
        $iv = mcrypt_create_iv($iv_size, MCRYPT_RAND);
        $decrypted_string = mcrypt_decrypt(MCRYPT_BLOWFISH, $encryption_key, $encrypted_string, MCRYPT_MODE_ECB, $iv);
        return $decrypted_string;
    }
    
    function hideContent($content,$token = null)
    {
        if($token == null) { $token = self::getRandomMD5Token(); }
        $startToken = substr($token, 22);
        $endToken = substr(strrev($token), 22);
        return ($startToken.rand(10000, 99999).$content.rand(100000, 999999).$endToken);
    }
    
    function showHiddenContent($hiddenContent)
    {
        return (strrev(substr(strrev(substr($hiddenContent, 15)), 16)));
    }
    
    public static function getRandomString($length = 8)
    {
        $letters = array('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        $str = '';
        for($i = 0; $i< $length; $i++) {
            $str .= $letters[rand(0, 61)];
        }
        return $str;
    }
    
    public static function getRandomMD5Token() {
        $tokens = array();
        $obj_cache = new Application_Model_Cache_Util();
        $cache = $obj_cache->getDBObject(Application_Model_Cache_Config::CACHE_DIR);
        $id = 'md5Tokens';
        if(($result = $cache->load($id)) === false) {
            for($i=0; $i<25; $i++) {
                array_push($tokens, md5(rand(100000, 999999)));
            }
            $cache->save($tokens, $id);
            return $tokens[rand(0, 24)];
        }else {
            return $result[rand(0, 24)];
        }
    }

}

