<?php

class Application_Model_Util_UserImage
{
	const IMAGE_PATH = '/profile/';
	
	const IMAGE1_FOLDER = 32;
	const IMAGE1_SIZE_X = 32;
	const IMAGE1_SIZE_Y = 32;
	
	const IMAGE2_FOLDER = 128;
	const IMAGE2_SIZE_X = 128;
	const IMAGE2_SIZE_Y = 128;
	
	const IMAGE3_FOLDER = 256;
	const IMAGE3_SIZE_X = 256;
	const IMAGE3_SIZE_Y = 256;
	
	public static function resize($image)
	{
		$img = new Imagick(Application_Model_Util_UserImage::getProjectFolderPath().$image);
		 
		$width= $img->getImageWidth();
		$height= $img->getImageHeight();
		$imgRatio = $width/$height;
	
		if(Application_Model_Util_UserImage::IMAGE1_SIZE_X > 0) {
			$desRatio = Application_Model_Util_UserImage::IMAGE1_SIZE_X/Application_Model_Util_UserImage::IMAGE1_SIZE_Y;
			if($desRatio > $imgRatio) {
				$img->scaleImage(Application_Model_Util_UserImage::IMAGE1_SIZE_X, 0);
			} else {
				$img->scaleImage(0, Application_Model_Util_UserImage::IMAGE1_SIZE_Y);
			}
			$img->writeImage(Application_Model_Util_UserImage::getProjectFolderPath().Application_Model_Util_UserImage::IMAGE1_FOLDER.'/'.$image);
		}
	
		if(Application_Model_Util_UserImage::IMAGE2_SIZE_X > 0) {
	
			$desRatio = Application_Model_Util_UserImage::IMAGE2_SIZE_X/Application_Model_Util_UserImage::IMAGE2_SIZE_Y;
			if($desRatio > $imgRatio) {
				$img->scaleImage(Application_Model_Util_UserImage::IMAGE2_SIZE_X, 0);
			} else {
				$img->scaleImage(0, Application_Model_Util_UserImage::IMAGE2_SIZE_Y);
			}
			$img->writeImage(Application_Model_Util_UserImage::getProjectFolderPath().Application_Model_Util_UserImage::IMAGE2_FOLDER.'/'.$image);
			 
		}
	
		if(Application_Model_Util_UserImage::IMAGE3_SIZE_X > 0) {
			$desRatio = Application_Model_Util_UserImage::IMAGE3_SIZE_X/Application_Model_Util_UserImage::IMAGE3_SIZE_Y;
			if($desRatio > $imgRatio) {
				$img->scaleImage(Application_Model_Util_UserImage::IMAGE3_SIZE_X, 0);
			} else {
				$img->scaleImage(0, Application_Model_Util_UserImage::IMAGE3_SIZE_Y);
			}
			$img->writeImage(Application_Model_Util_UserImage::getProjectFolderPath().Application_Model_Util_UserImage::IMAGE3_FOLDER.'/'.$image);
		}
	
		$img->destroy();
	}
	
	
	public static function getProjectFolderPath()
	{
		//return realpath(APPLICATION_PATH.'/'.Application_Model_Cache_Config::getConfig('UPLOAD_FOLDER_NAME')).Application_Model_Util_UserImage::IMAGE_PATH;
            return realpath(Application_Model_Cache_Config::getConfig('UPLOAD_FOLDER_NAME')).Application_Model_Util_UserImage::IMAGE_PATH;
	}

}