<?php

class Application_Model_Video extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_album_video';

    private $_id = null;

    private $_video_title = null;

    private $_video_desc = null;

    private $_video_code = null;

    private $_video_album = null;

    private $_video_status = null;

    private $_video_updated_by = null;

    private $_video_updated_date = null;

    private $_video_created_by = null;

    private $_video_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get video_title method is stand for get the value of video_title.
     *
     * @var varchar video_title
     */
    public function get_video_title()
    {
        return $this->_video_title;
    }

    /**
     * set video_title method is stand for set the value of video_title.
     *
     * @var varchar video_title
     */
    public function set_video_title($value)
    {
        $this->_video_title = $value;
    }

    /**
     * get video_desc method is stand for get the value of video_desc.
     *
     * @var varchar video_desc
     */
    public function get_video_desc()
    {
        return $this->_video_desc;
    }

    /**
     * set video_desc method is stand for set the value of video_desc.
     *
     * @var varchar video_desc
     */
    public function set_video_desc($value)
    {
        $this->_video_desc = $value;
    }

    /**
     * get video_code method is stand for get the value of video_code.
     *
     * @var varchar video_code
     */
    public function get_video_code()
    {
        return $this->_video_code;
    }

    /**
     * set video_code method is stand for set the value of video_code.
     *
     * @var varchar video_code
     */
    public function set_video_code($value)
    {
        $this->_video_code = $value;
    }

    /**
     * get video_album method is stand for get the value of video_album.
     *
     * @var int video_album
     */
    public function get_video_album()
    {
        return (int) $this->_video_album;
    }

    /**
     * set video_album method is stand for set the value of video_album.
     *
     * @var int video_album
     */
    public function set_video_album($value)
    {
        $this->_video_album = (int) $value;
    }

    /**
     * get video_status method is stand for get the value of video_status.
     *
     * @var varchar video_status
     */
    public function get_video_status()
    {
        return $this->_video_status;
    }

    /**
     * set video_status method is stand for set the value of video_status.
     *
     * @var varchar video_status
     */
    public function set_video_status($value)
    {
        $this->_video_status = $value;
    }

    /**
     * get video_updated_by method is stand for get the value of video_updated_by.
     *
     * @var int video_updated_by
     */
    public function get_video_updated_by()
    {
        return (int) $this->_video_updated_by;
    }

    /**
     * set video_updated_by method is stand for set the value of video_updated_by.
     *
     * @var int video_updated_by
     */
    public function set_video_updated_by($value)
    {
        $this->_video_updated_by = (int) $value;
    }

    /**
     * get video_updated_date method is stand for get the value of video_updated_date.
     *
     * @var timestamp video_updated_date
     */
    public function get_video_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_video_updated_date));
    }

    /**
     * set video_updated_date method is stand for set the value of video_updated_date.
     *
     * @var timestamp video_updated_date
     */
    public function set_video_updated_date($value)
    {
        $this->_video_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get video_created_by method is stand for get the value of video_created_by.
     *
     * @var int video_created_by
     */
    public function get_video_created_by()
    {
        return (int) $this->_video_created_by;
    }

    /**
     * set video_created_by method is stand for set the value of video_created_by.
     *
     * @var int video_created_by
     */
    public function set_video_created_by($value)
    {
        $this->_video_created_by = (int) $value;
    }

    /**
     * get video_created_date method is stand for get the value of video_created_date.
     *
     * @var timestamp video_created_date
     */
    public function get_video_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_video_created_date));
    }

    /**
     * set video_created_date method is stand for set the value of video_created_date.
     *
     * @var timestamp video_created_date
     */
    public function set_video_created_date($value)
    {
        $this->_video_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_album_video by set id thru constructor.
     *
     * @var int id
     * @var varchar video_title
     * @var varchar video_desc
     * @var varchar video_code
     * @var int video_album
     * @var varchar video_status
     * @var int video_updated_by
     * @var timestamp video_updated_date
     * @var int video_created_by
     * @var timestamp video_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_video_title($row->video_title);
          $this->set_video_desc($row->video_desc);
          $this->set_video_code($row->video_code);
          $this->set_video_album($row->video_album);
          $this->set_video_status($row->video_status);
          $this->set_video_updated_by($row->video_updated_by);
          $this->set_video_updated_date($row->video_updated_date);
          $this->set_video_created_by($row->video_created_by);
          $this->set_video_created_date($row->video_created_date);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var varchar video_title
     * @var varchar video_desc
     * @var varchar video_code
     * @var int video_album
     * @var varchar video_status
     * @var int video_updated_by
     * @var int video_created_by
     */
    public function save()
    {
        $data = array(
          "video_title" => $this->get_video_title(),
          "video_desc" => $this->get_video_desc(),
          "video_code" => $this->get_video_code(),
          "video_album" => $this->get_video_album(),
          "video_status" => $this->get_video_status(),
          "video_updated_by" => $this->get_video_updated_by(),
          "video_created_by" => $this->get_video_created_by());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from asit_album_video by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_video_title_by_id method is stand for get the value ofvideo_title By id.
     *
     * @var varchar video_title
     */
    public function get_video_title_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_video_title();
    }

    /**
     * get_video_desc_by_id method is stand for get the value ofvideo_desc By id.
     *
     * @var varchar video_desc
     */
    public function get_video_desc_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_video_desc();
    }

    /**
     * get_video_code_by_id method is stand for get the value ofvideo_code By id.
     *
     * @var varchar video_code
     */
    public function get_video_code_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_video_code();
    }

    /**
     * get_video_album_by_id method is stand for get the value ofvideo_album By id.
     *
     * @var int video_album
     */
    public function get_video_album_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_video_album();
    }

    /**
     * get_video_status_by_id method is stand for get the value ofvideo_status By id.
     *
     * @var varchar video_status
     */
    public function get_video_status_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_video_status();
    }

    /**
     * get_video_updated_by_by_id method is stand for get the value ofvideo_updated_by
     * By id.
     *
     * @var int video_updated_by
     */
    public function get_video_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_video_updated_by();
    }

    /**
     * get_video_updated_date_by_id method is stand for get the value
     * ofvideo_updated_date By id.
     *
     * @var timestamp video_updated_date
     */
    public function get_video_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_video_updated_date()));
    }

    /**
     * get_video_created_by_by_id method is stand for get the value ofvideo_created_by
     * By id.
     *
     * @var int video_created_by
     */
    public function get_video_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_video_created_by();
    }

    /**
     * get_video_created_date_by_id method is stand for get the value
     * ofvideo_created_date By id.
     *
     * @var timestamp video_created_date
     */
    public function get_video_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_video_created_date()));
    }


}
