<?php

class Application_Model_VideoLogic extends Application_Model_Video
{
    
    public function fetchOrdered($id)
    {
        return $this->fetchAll($this->select()->where('video_album = ?', $id)->where('video_status != ?', 'D')->order('video_title'));
    }
    
    public function fetchDataTableSelect($id) 
    {
        $columns = array('video_title', 'video_desc', 'video_status', 'action');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_VideoLogic(-1)), $columns);
        $where = $obj_data->get_where();
        $where->where('video_album = ?', $id)->where('video_status != ?', 'D');
        $obj_data->set_where($where);
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        $url = new Zend_View_Helper_Url();
        foreach($rows as $row)
        {
            $action = '';
            if(Application_Model_RolePermissionLogic::isPermitted("Album:Video:Edit")) {
                $action = '<a href="'.$url->url(array("controller"=>"video", "action"=>"edit", "id"=>$row->id)).'"><input type="button" value="Edit" class="btn btn-info" /></a> ';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("Album:Video:Delete")) {
                $action .= '<a href="'.$url->url(array("controller"=>"video", "action"=>"delete", "id"=>$row->id)).'"><input type="button" value="Delete" class="btn btn-danger" /></a>';
            }
            $status = Application_Model_Cache_Config::getConfig('STATUS_TYPE');
            $results[$i] = array($row->video_title, $row->video_desc, $status[$row->video_status], $action);
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }
}

