<?php
/**
 * Zend Model to intract with Database
 *
 * Asit list view Table Definition and Connection Coding.
 *
 * @package Sakshi Infotech Code
 * @name Asit list view Model
 * @filesource application/model
 * @author Akhil Gupta
 * @copyright Sakshi Infotech
 * @version 1.0
 * @license Sakshi Infotech
 * @subpackage Zend_Models
 */
class Application_Model_View_List extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_list_view';
    
    protected $_primary = 'id';

    private $_id = null;

    private $_list_title = null;

    private $_list_category = null;

    private $_category_title = null;

    private $_category_icon = null;

    private $_list_short_desc = null;

    private $_list_desc = null;

    private $_list_image = null;

    private $_list_tag_line = null;

    private $_list_address = null;

    private $_list_city = null;

    private $_city_name = null;

    private $_list_phone = null;

    private $_list_email = null;

    private $_list_website = null;

    private $_list_review_score = null;

    private $_list_review_total = null;

    private $_list_rate_ambience = null;

    private $_list_rate_food = null;

    private $_list_rate_service = null;

    private $_list_rate_value = null;

    private $_list_visitors = null;

    private $_list_abuse = null;

    private $_list_url = null;

    private $_list_type = null;

    private $_list_type_title = null;

    private $_list_status = null;

    private $_list_id = null;

    private $_list_fb = null;

    private $_list_tweet = null;

    private $_list_insta = null;

    private $_list_amenities = null;

    private $_list_target = null;

    private $_list_tags = null;

    private $_list_updated_by = null;

    private $_list_updated_date = null;

    private $_list_created_by = null;

    private $_list_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get list_title method is stand for get the value of list_title.
     *
     * @var varchar list_title
     */
    public function get_list_title()
    {
        return $this->_list_title;
    }

    /**
     * set list_title method is stand for set the value of list_title.
     *
     * @var varchar list_title
     */
    public function set_list_title($value)
    {
        $this->_list_title = $value;
    }

    /**
     * get list_category method is stand for get the value of list_category.
     *
     * @var int list_category
     */
    public function get_list_category()
    {
        return (int) $this->_list_category;
    }

    /**
     * set list_category method is stand for set the value of list_category.
     *
     * @var int list_category
     */
    public function set_list_category($value)
    {
        $this->_list_category = (int) $value;
    }

    /**
     * get category_title method is stand for get the value of category_title.
     *
     * @var varchar category_title
     */
    public function get_category_title()
    {
        return $this->_category_title;
    }

    /**
     * set category_title method is stand for set the value of category_title.
     *
     * @var varchar category_title
     */
    public function set_category_title($value)
    {
        $this->_category_title = $value;
    }

    /**
     * get category_icon method is stand for get the value of category_icon.
     *
     * @var varchar category_icon
     */
    public function get_category_icon()
    {
        return $this->_category_icon;
    }

    /**
     * set category_icon method is stand for set the value of category_icon.
     *
     * @var varchar category_icon
     */
    public function set_category_icon($value)
    {
        $this->_category_icon = $value;
    }

    /**
     * get list_short_desc method is stand for get the value of list_short_desc.
     *
     * @var varchar list_short_desc
     */
    public function get_list_short_desc()
    {
        return $this->_list_short_desc;
    }

    /**
     * set list_short_desc method is stand for set the value of list_short_desc.
     *
     * @var varchar list_short_desc
     */
    public function set_list_short_desc($value)
    {
        $this->_list_short_desc = $value;
    }

    /**
     * get list_desc method is stand for get the value of list_desc.
     *
     * @var text list_desc
     */
    public function get_list_desc()
    {
        return $this->_list_desc;
    }

    /**
     * set list_desc method is stand for set the value of list_desc.
     *
     * @var text list_desc
     */
    public function set_list_desc($value)
    {
        $this->_list_desc = $value;
    }

    /**
     * get list_image method is stand for get the value of list_image.
     *
     * @var varchar list_image
     */
    public function get_list_image()
    {
        return $this->_list_image;
    }

    /**
     * set list_image method is stand for set the value of list_image.
     *
     * @var varchar list_image
     */
    public function set_list_image($value)
    {
        $this->_list_image = $value;
    }

    /**
     * get list_tag_line method is stand for get the value of list_tag_line.
     *
     * @var varchar list_tag_line
     */
    public function get_list_tag_line()
    {
        return $this->_list_tag_line;
    }

    /**
     * set list_tag_line method is stand for set the value of list_tag_line.
     *
     * @var varchar list_tag_line
     */
    public function set_list_tag_line($value)
    {
        $this->_list_tag_line = $value;
    }

    /**
     * get list_address method is stand for get the value of list_address.
     *
     * @var varchar list_address
     */
    public function get_list_address()
    {
        return $this->_list_address;
    }

    /**
     * set list_address method is stand for set the value of list_address.
     *
     * @var varchar list_address
     */
    public function set_list_address($value)
    {
        $this->_list_address = $value;
    }

    /**
     * get list_city method is stand for get the value of list_city.
     *
     * @var int list_city
     */
    public function get_list_city()
    {
        return (int) $this->_list_city;
    }

    /**
     * set list_city method is stand for set the value of list_city.
     *
     * @var int list_city
     */
    public function set_list_city($value)
    {
        $this->_list_city = (int) $value;
    }

    /**
     * get city_name method is stand for get the value of city_name.
     *
     * @var varchar city_name
     */
    public function get_city_name()
    {
        return $this->_city_name;
    }

    /**
     * set city_name method is stand for set the value of city_name.
     *
     * @var varchar city_name
     */
    public function set_city_name($value)
    {
        $this->_city_name = $value;
    }

    /**
     * get list_phone method is stand for get the value of list_phone.
     *
     * @var varchar list_phone
     */
    public function get_list_phone()
    {
        return $this->_list_phone;
    }

    /**
     * set list_phone method is stand for set the value of list_phone.
     *
     * @var varchar list_phone
     */
    public function set_list_phone($value)
    {
        $this->_list_phone = $value;
    }

    /**
     * get list_email method is stand for get the value of list_email.
     *
     * @var varchar list_email
     */
    public function get_list_email()
    {
        return $this->_list_email;
    }

    /**
     * set list_email method is stand for set the value of list_email.
     *
     * @var varchar list_email
     */
    public function set_list_email($value)
    {
        $this->_list_email = $value;
    }

    /**
     * get list_website method is stand for get the value of list_website.
     *
     * @var varchar list_website
     */
    public function get_list_website()
    {
        return $this->_list_website;
    }

    /**
     * set list_website method is stand for set the value of list_website.
     *
     * @var varchar list_website
     */
    public function set_list_website($value)
    {
        $this->_list_website = $value;
    }

    /**
     * get list_review_score method is stand for get the value of list_review_score.
     *
     * @var float list_review_score
     */
    public function get_list_review_score()
    {
        return $this->_list_review_score;
    }

    /**
     * set list_review_score method is stand for set the value of list_review_score.
     *
     * @var float list_review_score
     */
    public function set_list_review_score($value)
    {
        $this->_list_review_score = $value;
    }

    /**
     * get list_review_total method is stand for get the value of list_review_total.
     *
     * @var int list_review_total
     */
    public function get_list_review_total()
    {
        return (int) $this->_list_review_total;
    }

    /**
     * set list_review_total method is stand for set the value of list_review_total.
     *
     * @var int list_review_total
     */
    public function set_list_review_total($value)
    {
        $this->_list_review_total = (int) $value;
    }

    /**
     * get list_rate_ambience method is stand for get the value of list_rate_ambience.
     *
     * @var tinyint list_rate_ambience
     */
    public function get_list_rate_ambience()
    {
        return $this->_list_rate_ambience;
    }

    /**
     * set list_rate_ambience method is stand for set the value of list_rate_ambience.
     *
     * @var tinyint list_rate_ambience
     */
    public function set_list_rate_ambience($value)
    {
        $this->_list_rate_ambience = $value;
    }

    /**
     * get list_rate_food method is stand for get the value of list_rate_food.
     *
     * @var tinyint list_rate_food
     */
    public function get_list_rate_food()
    {
        return $this->_list_rate_food;
    }

    /**
     * set list_rate_food method is stand for set the value of list_rate_food.
     *
     * @var tinyint list_rate_food
     */
    public function set_list_rate_food($value)
    {
        $this->_list_rate_food = $value;
    }

    /**
     * get list_rate_service method is stand for get the value of list_rate_service.
     *
     * @var tinyint list_rate_service
     */
    public function get_list_rate_service()
    {
        return $this->_list_rate_service;
    }

    /**
     * set list_rate_service method is stand for set the value of list_rate_service.
     *
     * @var tinyint list_rate_service
     */
    public function set_list_rate_service($value)
    {
        $this->_list_rate_service = $value;
    }

    /**
     * get list_rate_value method is stand for get the value of list_rate_value.
     *
     * @var tinyint list_rate_value
     */
    public function get_list_rate_value()
    {
        return $this->_list_rate_value;
    }

    /**
     * set list_rate_value method is stand for set the value of list_rate_value.
     *
     * @var tinyint list_rate_value
     */
    public function set_list_rate_value($value)
    {
        $this->_list_rate_value = $value;
    }

    /**
     * get list_visitors method is stand for get the value of list_visitors.
     *
     * @var int list_visitors
     */
    public function get_list_visitors()
    {
        return (int) $this->_list_visitors;
    }

    /**
     * set list_visitors method is stand for set the value of list_visitors.
     *
     * @var int list_visitors
     */
    public function set_list_visitors($value)
    {
        $this->_list_visitors = (int) $value;
    }

    /**
     * get list_abuse method is stand for get the value of list_abuse.
     *
     * @var int list_abuse
     */
    public function get_list_abuse()
    {
        return (int) $this->_list_abuse;
    }

    /**
     * set list_abuse method is stand for set the value of list_abuse.
     *
     * @var int list_abuse
     */
    public function set_list_abuse($value)
    {
        $this->_list_abuse = (int) $value;
    }

    /**
     * get list_url method is stand for get the value of list_url.
     *
     * @var varchar list_url
     */
    public function get_list_url()
    {
        return $this->_list_url;
    }

    /**
     * set list_url method is stand for set the value of list_url.
     *
     * @var varchar list_url
     */
    public function set_list_url($value)
    {
        $this->_list_url = $value;
    }

    /**
     * get list_type method is stand for get the value of list_type.
     *
     * @var varchar list_type
     */
    public function get_list_type()
    {
        return $this->_list_type;
    }

    /**
     * set list_type method is stand for set the value of list_type.
     *
     * @var varchar list_type
     */
    public function set_list_type($value)
    {
        $this->_list_type = $value;
    }

    /**
     * get list_type_title method is stand for get the value of list_type_title.
     *
     * @var varchar list_type_title
     */
    public function get_list_type_title()
    {
        return $this->_list_type_title;
    }

    /**
     * set list_type_title method is stand for set the value of list_type_title.
     *
     * @var varchar list_type_title
     */
    public function set_list_type_title($value)
    {
        $this->_list_type_title = $value;
    }

    /**
     * get list_status method is stand for get the value of list_status.
     *
     * @var varchar list_status
     */
    public function get_list_status()
    {
        return $this->_list_status;
    }

    /**
     * set list_status method is stand for set the value of list_status.
     *
     * @var varchar list_status
     */
    public function set_list_status($value)
    {
        $this->_list_status = $value;
    }

    /**
     * get list_id method is stand for get the value of list_id.
     *
     * @var int list_id
     */
    public function get_list_id()
    {
        return (int) $this->_list_id;
    }

    /**
     * set list_id method is stand for set the value of list_id.
     *
     * @var int list_id
     */
    public function set_list_id($value)
    {
        $this->_list_id = (int) $value;
    }

    /**
     * get list_fb method is stand for get the value of list_fb.
     *
     * @var varchar list_fb
     */
    public function get_list_fb()
    {
        return $this->_list_fb;
    }

    /**
     * set list_fb method is stand for set the value of list_fb.
     *
     * @var varchar list_fb
     */
    public function set_list_fb($value)
    {
        $this->_list_fb = $value;
    }

    /**
     * get list_tweet method is stand for get the value of list_tweet.
     *
     * @var varchar list_tweet
     */
    public function get_list_tweet()
    {
        return $this->_list_tweet;
    }

    /**
     * set list_tweet method is stand for set the value of list_tweet.
     *
     * @var varchar list_tweet
     */
    public function set_list_tweet($value)
    {
        $this->_list_tweet = $value;
    }

    /**
     * get list_insta method is stand for get the value of list_insta.
     *
     * @var varchar list_insta
     */
    public function get_list_insta()
    {
        return $this->_list_insta;
    }

    /**
     * set list_insta method is stand for set the value of list_insta.
     *
     * @var varchar list_insta
     */
    public function set_list_insta($value)
    {
        $this->_list_insta = $value;
    }

    /**
     * get list_amenities method is stand for get the value of list_amenities.
     *
     * @var varchar list_amenities
     */
    public function get_list_amenities()
    {
        return $this->_list_amenities;
    }

    /**
     * set list_amenities method is stand for set the value of list_amenities.
     *
     * @var varchar list_amenities
     */
    public function set_list_amenities($value)
    {
        $this->_list_amenities = $value;
    }

    /**
     * get list_target method is stand for get the value of list_target.
     *
     * @var varchar list_target
     */
    public function get_list_target()
    {
        return $this->_list_target;
    }

    /**
     * set list_target method is stand for set the value of list_target.
     *
     * @var varchar list_target
     */
    public function set_list_target($value)
    {
        $this->_list_target = $value;
    }

    /**
     * get list_tags method is stand for get the value of list_tags.
     *
     * @var varchar list_tags
     */
    public function get_list_tags()
    {
        return $this->_list_tags;
    }

    /**
     * set list_tags method is stand for set the value of list_tags.
     *
     * @var varchar list_tags
     */
    public function set_list_tags($value)
    {
        $this->_list_tags = $value;
    }

    /**
     * get list_updated_by method is stand for get the value of list_updated_by.
     *
     * @var int list_updated_by
     */
    public function get_list_updated_by()
    {
        return (int) $this->_list_updated_by;
    }

    /**
     * set list_updated_by method is stand for set the value of list_updated_by.
     *
     * @var int list_updated_by
     */
    public function set_list_updated_by($value)
    {
        $this->_list_updated_by = (int) $value;
    }

    /**
     * get list_updated_date method is stand for get the value of list_updated_date.
     *
     * @var timestamp list_updated_date
     */
    public function get_list_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_list_updated_date));
    }

    /**
     * set list_updated_date method is stand for set the value of list_updated_date.
     *
     * @var timestamp list_updated_date
     */
    public function set_list_updated_date($value)
    {
        $this->_list_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get list_created_by method is stand for get the value of list_created_by.
     *
     * @var int list_created_by
     */
    public function get_list_created_by()
    {
        return (int) $this->_list_created_by;
    }

    /**
     * set list_created_by method is stand for set the value of list_created_by.
     *
     * @var int list_created_by
     */
    public function set_list_created_by($value)
    {
        $this->_list_created_by = (int) $value;
    }

    /**
     * get list_created_date method is stand for get the value of list_created_date.
     *
     * @var timestamp list_created_date
     */
    public function get_list_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_list_created_date));
    }

    /**
     * set list_created_date method is stand for set the value of list_created_date.
     *
     * @var timestamp list_created_date
     */
    public function set_list_created_date($value)
    {
        $this->_list_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_list_view by set id thru constructor.
     *
     * @var int id
     * @var varchar list_title
     * @var int list_category
     * @var varchar category_title
     * @var varchar category_icon
     * @var varchar list_short_desc
     * @var text list_desc
     * @var varchar list_image
     * @var varchar list_tag_line
     * @var varchar list_address
     * @var int list_city
     * @var varchar city_name
     * @var varchar list_phone
     * @var varchar list_email
     * @var varchar list_website
     * @var float list_review_score
     * @var int list_review_total
     * @var tinyint list_rate_ambience
     * @var tinyint list_rate_food
     * @var tinyint list_rate_service
     * @var tinyint list_rate_value
     * @var int list_visitors
     * @var int list_abuse
     * @var varchar list_url
     * @var varchar list_type
     * @var varchar list_type_title
     * @var varchar list_status
     * @var int list_id
     * @var varchar list_fb
     * @var varchar list_tweet
     * @var varchar list_insta
     * @var varchar list_amenities
     * @var varchar list_target
     * @var varchar list_tags
     * @var int list_updated_by
     * @var timestamp list_updated_date
     * @var int list_created_by
     * @var timestamp list_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_list_title($row->list_title);
          $this->set_list_category($row->list_category);
          $this->set_category_title($row->category_title);
          $this->set_category_icon($row->category_icon);
          $this->set_list_short_desc($row->list_short_desc);
          $this->set_list_desc($row->list_desc);
          $this->set_list_image($row->list_image);
          $this->set_list_tag_line($row->list_tag_line);
          $this->set_list_address($row->list_address);
          $this->set_list_city($row->list_city);
          $this->set_city_name($row->city_name);
          $this->set_list_phone($row->list_phone);
          $this->set_list_email($row->list_email);
          $this->set_list_website($row->list_website);
          $this->set_list_review_score($row->list_review_score);
          $this->set_list_review_total($row->list_review_total);
          $this->set_list_rate_ambience($row->list_rate_ambience);
          $this->set_list_rate_food($row->list_rate_food);
          $this->set_list_rate_service($row->list_rate_service);
          $this->set_list_rate_value($row->list_rate_value);
          $this->set_list_visitors($row->list_visitors);
          $this->set_list_abuse($row->list_abuse);
          $this->set_list_url($row->list_url);
          $this->set_list_type($row->list_type);
          $this->set_list_type_title($row->list_type_title);
          $this->set_list_status($row->list_status);
          $this->set_list_id($row->list_id);
          $this->set_list_fb($row->list_fb);
          $this->set_list_tweet($row->list_tweet);
          $this->set_list_insta($row->list_insta);
          $this->set_list_amenities($row->list_amenities);
          $this->set_list_target($row->list_target);
          $this->set_list_tags($row->list_tags);
          $this->set_list_updated_by($row->list_updated_by);
          $this->set_list_updated_date($row->list_updated_date);
          $this->set_list_created_by($row->list_created_by);
          $this->set_list_created_date($row->list_created_date);
        }
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }
}
