<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of ListView
 *
 * @author Akhil Kumar
 */
class Application_Model_View_ListLogic extends Application_Model_View_List {
    
    public function getRelatedListing($category) {
        $where = $this->select()->where('list_category = ?', $category)->order('list_review_score desc')->limit(4);
        return $this->fetchAll($where);
    }
    
    public function getListingsByCity($city) {
        $where = $this->select()->where('list_status  = ?', 'A')->where('list_city  = ?', $city);
        return $where;
    }
    
    public function searchListings($query) {
        $where = $this->select()->where('list_status  = ?', 'A');
        $select = $this->select()->orWhere('list_title like ?', '%'.$query.'%')->orWhere('category_title like ?', '%'.$query.'%')
                ->orWhere('list_short_desc like ?', '%'.$query.'%')->orWhere('list_desc like ?', '%'.$query.'%')
                ->orWhere('list_tag_line like ?', '%'.$query.'%')->orWhere('city_name like ?', '%'.$query.'%')
                ->orWhere('list_phone like ?', '%'.$query.'%')->orWhere('list_email like ?', '%'.$query.'%')
                ->orWhere('list_website like ?', '%'.$query.'%')->orWhere('list_tags like ?', '%'.$query.'%')
                ->orWhere('list_type_title like ?', '%'.$query.'%');
        $where->where(implode(' ', $select->getPart(Zend_Db_Select::WHERE)))->order('id desc');
        return $where;
    }
    
    public function filterListings($data) {
        $where = $this->select()->where('list_status  = ?', 'A');
        $citySelect = null;
        if(!empty($data['city']) && is_array($data['city']) && count($data['city']) > 0) {
            $city = $data['city'];
            $citySelect = $this->select();
            foreach($city as $c) {
                $citySelect->orWhere('list_city = ?', $c);
            }
        }
        $catSelect = null;
        if(!empty($data['category']) && is_array($data['category']) && count($data['category']) > 0) {
            $category = $data['category'];
            $catSelect = $this->select();
            foreach($category as $cat) {
                $catSelect->orWhere('list_category = ?', $category)->orWhere('id in (select list_id from asit_list_category where list_category_status = \'A\' and category_id = ?)', $cat);
            }
        }
        $amenitySelect = null;
        if(!empty($data['amenity']) && is_array($amenities) && count($amenities) > 0) {
            $amenities = $data['amenity'];
            $amenitySelect = $this->select();
            foreach($amenities as $amenity) {
                $amenitySelect->orWhere('list_amenities like ?', '%'.$amenity.'%');
            }
        }
        
        $targetSelect = null;
        if(!empty($data['target']) && is_array($data['target']) && count($data['target']) > 0) {
            $targets = $data['target'];
            $targetSelect = $this->select();
            foreach($targets as $target) {
                $targetSelect->orWhere('list_target like ?', '%'.$target.'%');
            }
        }
        if(null != $citySelect) {
            $where->where(implode(' ', $citySelect->getPart(Zend_Db_Select::WHERE)));
        }
        if(null != $catSelect) {
            $where->where(implode(' ', $catSelect->getPart(Zend_Db_Select::WHERE)));
        }
        if(null != $amenitySelect) {
            $where->where(implode(' ', $amenitySelect->getPart(Zend_Db_Select::WHERE)));
        }
        if(null != $targetSelect) {
            $where->where(implode(' ', $targetSelect->getPart(Zend_Db_Select::WHERE)));
        }
        if(!empty($data['query']) && is_array($data['query']) && count($data['query']) > 0) {
            $query = $data['query'];
            $select = $this->select()->orWhere('list_title like ?', '%'.$query.'%')->orWhere('category_title like ?', '%'.$query.'%')
                    ->orWhere('list_short_desc like ?', '%'.$query.'%')->orWhere('list_desc like ?', '%'.$query.'%')
                    ->orWhere('list_tag_line like ?', '%'.$query.'%')->orWhere('city_name like ?', '%'.$query.'%')
                    ->orWhere('list_phone like ?', '%'.$query.'%')->orWhere('list_email like ?', '%'.$query.'%')
                    ->orWhere('list_website like ?', '%'.$query.'%')->orWhere('list_tags like ?', '%'.$query.'%')
                    ->orWhere('list_type_title like ?', '%'.$query.'%');
            $where->where(implode(' ', $select->getPart(Zend_Db_Select::WHERE)));
        }
        
        $where->order('id desc');
        return $where;
    }
    
    public function getListingsByCategory($catId) {
        if($catId > 0){
            $where = $this->select()->where('list_status  = ?', 'A');
            $select = $this->select()->where('list_category = ?', $catId)->orWhere('id in (select list_id from asit_list_category where list_category_status = \'A\' and category_id = ?)', $catId);
            $where->where(implode(' ', $select->getPart(Zend_Db_Select::WHERE)))->order('id desc');
            return $where;
        }else {
            return null;
        }
    }
    
    public function searchWords($query) {
        $q = $this->getAdapter()->query('select * from asit_view_search_term where lower(title) like ? order by title', array('%'.strtolower($query).'%'));
        return $q->fetchAll();
    }
}
