<?php

class Application_Model_Work extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_work';

    private $_id = null;

    private $_work_title = null;

    private $_work_description = null;

    private $_work_from_date = null;

    private $_work_to_date = null;

    private $_work_user_id = null;

    private $_work_role_id = null;

    private $_work_status = null;

    private $_work_priority = null;

    private $_work_remarks = null;

    private $_work_updated_by = null;

    private $_work_updated_date = null;

    private $_work_created_by = null;

    private $_work_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get work_title method is stand for get the value of work_title.
     *
     * @var varchar work_title
     */
    public function get_work_title()
    {
        return $this->_work_title;
    }

    /**
     * set work_title method is stand for set the value of work_title.
     *
     * @var varchar work_title
     */
    public function set_work_title($value)
    {
        $this->_work_title = $value;
    }

    /**
     * get work_description method is stand for get the value of work_description.
     *
     * @var varchar work_description
     */
    public function get_work_description()
    {
        return $this->_work_description;
    }

    /**
     * set work_description method is stand for set the value of work_description.
     *
     * @var varchar work_description
     */
    public function set_work_description($value)
    {
        $this->_work_description = $value;
    }

    /**
     * get work_from_date method is stand for get the value of work_from_date.
     *
     * @var date work_from_date
     */
    public function get_work_from_date()
    {
        return date("d-M-Y", strtotime($this->_work_from_date));
    }

    /**
     * set work_from_date method is stand for set the value of work_from_date.
     *
     * @var date work_from_date
     */
    public function set_work_from_date($value)
    {
        $this->_work_from_date = date("Y-m-d", strtotime($value));
    }

    /**
     * get work_to_date method is stand for get the value of work_to_date.
     *
     * @var date work_to_date
     */
    public function get_work_to_date()
    {
        return date("d-M-Y", strtotime($this->_work_to_date));
    }

    /**
     * set work_to_date method is stand for set the value of work_to_date.
     *
     * @var date work_to_date
     */
    public function set_work_to_date($value)
    {
        $this->_work_to_date = date("Y-m-d", strtotime($value));
    }

    /**
     * get work_user_id method is stand for get the value of work_user_id.
     *
     * @var int work_user_id
     */
    public function get_work_user_id()
    {
        return (int) $this->_work_user_id;
    }

    /**
     * set work_user_id method is stand for set the value of work_user_id.
     *
     * @var int work_user_id
     */
    public function set_work_user_id($value)
    {
        $this->_work_user_id = (int) $value;
    }

    /**
     * get work_role_id method is stand for get the value of work_role_id.
     *
     * @var int work_role_id
     */
    public function get_work_role_id()
    {
        return (int) $this->_work_role_id;
    }

    /**
     * set work_role_id method is stand for set the value of work_role_id.
     *
     * @var int work_role_id
     */
    public function set_work_role_id($value)
    {
        $this->_work_role_id = (int) $value;
    }

    /**
     * get work_status method is stand for get the value of work_status.
     *
     * @var varchar work_status
     */
    public function get_work_status()
    {
        return $this->_work_status;
    }

    /**
     * set work_status method is stand for set the value of work_status.
     *
     * @var varchar work_status
     */
    public function set_work_status($value)
    {
        $this->_work_status = $value;
    }

    /**
     * get work_priority method is stand for get the value of work_priority.
     *
     * @var int work_priority
     */
    public function get_work_priority()
    {
        return $this->_work_priority;
    }

    /**
     * set work_priority method is stand for set the value of work_priority.
     *
     * @var int work_priority
     */
    public function set_work_priority($value)
    {
        $this->_work_priority = $value;
    }

    /**
     * get work_remarks method is stand for get the value of work_remarks.
     *
     * @var varchar work_remarks
     */
    public function get_work_remarks()
    {
        return $this->_work_remarks;
    }

    /**
     * set work_remarks method is stand for set the value of work_remarks.
     *
     * @var varchar work_remarks
     */
    public function set_work_remarks($value)
    {
        $this->_work_remarks = $value;
    }

    /**
     * get work_updated_by method is stand for get the value of work_updated_by.
     *
     * @var int work_updated_by
     */
    public function get_work_updated_by()
    {
        return (int) $this->_work_updated_by;
    }

    /**
     * set work_updated_by method is stand for set the value of work_updated_by.
     *
     * @var int work_updated_by
     */
    public function set_work_updated_by($value)
    {
        $this->_work_updated_by = (int) $value;
    }

    /**
     * get work_updated_date method is stand for get the value of work_updated_date.
     *
     * @var timestamp work_updated_date
     */
    public function get_work_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_work_updated_date));
    }

    /**
     * set work_updated_date method is stand for set the value of work_updated_date.
     *
     * @var timestamp work_updated_date
     */
    public function set_work_updated_date($value)
    {
        $this->_work_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get work_created_by method is stand for get the value of work_created_by.
     *
     * @var int work_created_by
     */
    public function get_work_created_by()
    {
        return (int) $this->_work_created_by;
    }

    /**
     * set work_created_by method is stand for set the value of work_created_by.
     *
     * @var int work_created_by
     */
    public function set_work_created_by($value)
    {
        $this->_work_created_by = (int) $value;
    }

    /**
     * get work_created_date method is stand for get the value of work_created_date.
     *
     * @var timestamp work_created_date
     */
    public function get_work_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_work_created_date));
    }

    /**
     * set work_created_date method is stand for set the value of work_created_date.
     *
     * @var timestamp work_created_date
     */
    public function set_work_created_date($value)
    {
        $this->_work_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_work by set id thru constructor.
     *
     * @var int id
     * @var varchar work_title
     * @var varchar work_description
     * @var date work_from_date
     * @var date work_to_date
     * @var int work_user_id
     * @var int work_role_id
     * @var varchar work_status
     * @var int work_priority
     * @var varchar work_remarks
     * @var int work_updated_by
     * @var timestamp work_updated_date
     * @var int work_created_by
     * @var timestamp work_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_work_title($row->work_title);
          $this->set_work_description($row->work_description);
          $this->set_work_from_date($row->work_from_date);
          $this->set_work_to_date($row->work_to_date);
          $this->set_work_user_id($row->work_user_id);
          $this->set_work_role_id($row->work_role_id);
          $this->set_work_status($row->work_status);
          $this->set_work_priority($row->work_priority);
          $this->set_work_remarks($row->work_remarks);
          $this->set_work_updated_by($row->work_updated_by);
          $this->set_work_updated_date($row->work_updated_date);
          $this->set_work_created_by($row->work_created_by);
          $this->set_work_created_date($row->work_created_date);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var varchar work_title
     * @var varchar work_description
     * @var date work_from_date
     * @var date work_to_date
     * @var int work_user_id
     * @var int work_role_id
     * @var varchar work_status
     * @var int work_priority
     * @var varchar work_remarks
     * @var int work_updated_by
     * @var int work_created_by
     */
    public function save()
    {
        $data = array(
          "work_title" => $this->get_work_title(),
          "work_description" => $this->get_work_description(),
          "work_from_date" => date("Y-m-d", strtotime($this->get_work_from_date())),
          "work_to_date" => date("Y-m-d", strtotime($this->get_work_to_date())),
          "work_user_id" => $this->get_work_user_id(),
          "work_role_id" => $this->get_work_role_id(),
          "work_status" => $this->get_work_status(),
          "work_priority" => $this->get_work_priority(),
          "work_remarks" => $this->get_work_remarks(),
          "work_updated_by" => $this->get_work_updated_by(),
          "work_created_by" => $this->get_work_created_by());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from asit_work by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_work_title_by_id method is stand for get the value ofwork_title By id.
     *
     * @var varchar work_title
     */
    public function get_work_title_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_work_title();
    }

    /**
     * get_work_description_by_id method is stand for get the value ofwork_description
     * By id.
     *
     * @var varchar work_description
     */
    public function get_work_description_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_work_description();
    }

    /**
     * get_work_from_date_by_id method is stand for get the value ofwork_from_date By
     * id.
     *
     * @var date work_from_date
     */
    public function get_work_from_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y", strtotime($this->get_work_from_date()));
    }

    /**
     * get_work_to_date_by_id method is stand for get the value ofwork_to_date By id.
     *
     * @var date work_to_date
     */
    public function get_work_to_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y", strtotime($this->get_work_to_date()));
    }

    /**
     * get_work_user_id_by_id method is stand for get the value ofwork_user_id By id.
     *
     * @var int work_user_id
     */
    public function get_work_user_id_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_work_user_id();
    }

    /**
     * get_work_role_id_by_id method is stand for get the value ofwork_role_id By id.
     *
     * @var int work_role_id
     */
    public function get_work_role_id_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_work_role_id();
    }

    /**
     * get_work_status_by_id method is stand for get the value ofwork_status By id.
     *
     * @var varchar work_status
     */
    public function get_work_status_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_work_status();
    }

    /**
     * get_work_priority_by_id method is stand for get the value ofwork_priority By id.
     *
     * @var int work_priority
     */
    public function get_work_priority_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_work_priority();
    }

    /**
     * get_work_remarks_by_id method is stand for get the value ofwork_remarks By id.
     *
     * @var varchar work_remarks
     */
    public function get_work_remarks_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_work_remarks();
    }

    /**
     * get_work_updated_by_by_id method is stand for get the value ofwork_updated_by By
     * id.
     *
     * @var int work_updated_by
     */
    public function get_work_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_work_updated_by();
    }

    /**
     * get_work_updated_date_by_id method is stand for get the value
     * ofwork_updated_date By id.
     *
     * @var timestamp work_updated_date
     */
    public function get_work_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_work_updated_date()));
    }

    /**
     * get_work_created_by_by_id method is stand for get the value ofwork_created_by By
     * id.
     *
     * @var int work_created_by
     */
    public function get_work_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_work_created_by();
    }

    /**
     * get_work_created_date_by_id method is stand for get the value
     * ofwork_created_date By id.
     *
     * @var timestamp work_created_date
     */
    public function get_work_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_work_created_date()));
    }


}
