<?php

class Application_Model_WorkLogic extends Application_Model_Work
{
    
    public static $priority = array("L"=>"Low", "M"=>"Medium", "H"=>"High", "U"=>"Urgent");
    
    public function fetchDataTableSelect() 
    {
        $columns = array('work_title', 'work_status', 'work_from_date', 'work_to_date', 'action');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_WorkLogic(-1)), $columns);
        $where = $obj_data->get_where();
        $obj_user = new Application_Model_UserLogic(-1);
        $user = $obj_user->getLoggedInUser();
        $where->where('work_status != ?', 'D');
        $where->where("(work_user_id = '".$user->get_id()."' or work_created_by = '".$user->get_id()."' or work_role_id = '".$user->get_user_role()."')");
        $obj_data->set_where($where);
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        $url = new Zend_View_Helper_Url();
        foreach($rows as $row)
        {
            $action = '';
            if(Application_Model_RolePermissionLogic::isPermitted("Work:Master") && ($row->work_user_id == $user->get_id() || $row->work_role_id == $user->get_user_role())) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"work-status", "action"=>"add", "id"=>$row->id)).'"><input type="button" value="Update Status" class="btn btn-primary" /></a>';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("Work:Edit") && $row->work_created_by == $user->get_id()) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"work-status", "action"=>"index", "id"=>$row->id)).'"><input type="button" value="View" class="btn btn-gray4" /></a>';
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"work", "action"=>"edit", "id"=>$row->id)).'"><input type="button" value="Edit" class="btn btn-info" /></a>';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("Work:Delete") && $row->work_created_by == $user->get_id()) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"work", "action"=>"delete", "id"=>$row->id)).'"><input type="button" value="Delete" class="btn btn-danger" /></a>';
            }
            $results[$i] = array($row->work_title, $row->work_status, $this->getAllotedStr($row->id), date('d-M-Y', strtotime($row->work_from_date)), date('d-M-Y', strtotime($row->work_to_date)), $action);
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }

    public function insertStatus($id, $status, $remarks)
    {
        $user = new Application_Model_UserLogic(-1);
        $this->set_id($id);
        $this->fetch();
        $this->set_work_status($status);
        $this->set_work_remarks($remarks);
        $this->set_work_updated_by($user->getLoggedInUserId());
        $this->save();
    }

    public function getActiveWorksByUser($start, $end)
    {
        $obj_user = new Application_Model_UserLogic(-1);
        $user = $obj_user->getLoggedInUser();
        $where = $this->select()->where('work_status != ?', 'D')->where('work_from_date <= ?', $end)->where('work_to_date >= ?', $start);
        if($user->get_user_role() != Application_Model_Cache_Config::getConfig('SUPER_ADMIN_ROLE')) {
            $select = $this->select();
            $select->orWhere('work_user_id = ?', $user->get_id())->orWhere('work_role_id = ?', $user->get_user_role());
            $where->where(implode(' ',$select->getPart(Zend_Db_Select::WHERE)));
        }
        return $this->fetchAll($where);
    }
    
    public function getAllotedStr($id)
    {
        $alloted = '';
        $this->set_id($id);
        $this->fetch();
        if($this->get_work_role_id() > 0) {
            $obj_role = new Application_Model_RoleLogic($this->get_work_role_id());
            $alloted = '<b>Role:</b> '.$obj_role->get_role_title();
        }
        if($this->get_work_user_id() > 0) {
            $obj_user = new Application_Model_UserLogic($this->get_work_user_id());
            $alloted = '<b>User:</b> '.$obj_user->get_user_name();
        }
        return $alloted;
    }
    
}

