<?php

class Application_Model_WorkStatus extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_work_status';

    private $_id = null;

    private $_work_id = null;

    private $_work_remarks = null;

    private $_work_status = null;

    private $_work_updated_by = null;

    private $_work_updated_date = null;

    private $_work_created_by = null;

    private $_work_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get work_id method is stand for get the value of work_id.
     *
     * @var int work_id
     */
    public function get_work_id()
    {
        return (int) $this->_work_id;
    }

    /**
     * set work_id method is stand for set the value of work_id.
     *
     * @var int work_id
     */
    public function set_work_id($value)
    {
        $this->_work_id = (int) $value;
    }

    /**
     * get work_remarks method is stand for get the value of work_remarks.
     *
     * @var varchar work_remarks
     */
    public function get_work_remarks()
    {
        return $this->_work_remarks;
    }

    /**
     * set work_remarks method is stand for set the value of work_remarks.
     *
     * @var varchar work_remarks
     */
    public function set_work_remarks($value)
    {
        $this->_work_remarks = $value;
    }

    /**
     * get work_status method is stand for get the value of work_status.
     *
     * @var varchar work_status
     */
    public function get_work_status()
    {
        return $this->_work_status;
    }

    /**
     * set work_status method is stand for set the value of work_status.
     *
     * @var varchar work_status
     */
    public function set_work_status($value)
    {
        $this->_work_status = $value;
    }

    /**
     * get work_updated_by method is stand for get the value of work_updated_by.
     *
     * @var int work_updated_by
     */
    public function get_work_updated_by()
    {
        return (int) $this->_work_updated_by;
    }

    /**
     * set work_updated_by method is stand for set the value of work_updated_by.
     *
     * @var int work_updated_by
     */
    public function set_work_updated_by($value)
    {
        $this->_work_updated_by = (int) $value;
    }

    /**
     * get work_updated_date method is stand for get the value of work_updated_date.
     *
     * @var timestamp work_updated_date
     */
    public function get_work_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_work_updated_date));
    }

    /**
     * set work_updated_date method is stand for set the value of work_updated_date.
     *
     * @var timestamp work_updated_date
     */
    public function set_work_updated_date($value)
    {
        $this->_work_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get work_created_by method is stand for get the value of work_created_by.
     *
     * @var int work_created_by
     */
    public function get_work_created_by()
    {
        return (int) $this->_work_created_by;
    }

    /**
     * set work_created_by method is stand for set the value of work_created_by.
     *
     * @var int work_created_by
     */
    public function set_work_created_by($value)
    {
        $this->_work_created_by = (int) $value;
    }

    /**
     * get work_created_date method is stand for get the value of work_created_date.
     *
     * @var timestamp work_created_date
     */
    public function get_work_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_work_created_date));
    }

    /**
     * set work_created_date method is stand for set the value of work_created_date.
     *
     * @var timestamp work_created_date
     */
    public function set_work_created_date($value)
    {
        $this->_work_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_work_status by set id thru constructor.
     *
     * @var int id
     * @var int work_id
     * @var varchar work_remarks
     * @var varchar work_status
     * @var int work_updated_by
     * @var timestamp work_updated_date
     * @var int work_created_by
     * @var timestamp work_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_work_id($row->work_id);
          $this->set_work_remarks($row->work_remarks);
          $this->set_work_status($row->work_status);
          $this->set_work_updated_by($row->work_updated_by);
          $this->set_work_updated_date($row->work_updated_date);
          $this->set_work_created_by($row->work_created_by);
          $this->set_work_created_date($row->work_created_date);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var int work_id
     * @var varchar work_remarks
     * @var varchar work_status
     * @var int work_updated_by
     * @var int work_created_by
     */
    public function save()
    {
        $data = array(
          "work_id" => $this->get_work_id(),
          "work_remarks" => $this->get_work_remarks(),
          "work_status" => $this->get_work_status(),
          "work_updated_by" => $this->get_work_updated_by(),
          "work_created_by" => $this->get_work_created_by());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from asit_work_status by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_work_id_by_id method is stand for get the value ofwork_id By id.
     *
     * @var int work_id
     */
    public function get_work_id_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_work_id();
    }

    /**
     * get_work_remarks_by_id method is stand for get the value ofwork_remarks By id.
     *
     * @var varchar work_remarks
     */
    public function get_work_remarks_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_work_remarks();
    }

    /**
     * get_work_status_by_id method is stand for get the value ofwork_status By id.
     *
     * @var varchar work_status
     */
    public function get_work_status_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_work_status();
    }

    /**
     * get_work_updated_by_by_id method is stand for get the value ofwork_updated_by By
     * id.
     *
     * @var int work_updated_by
     */
    public function get_work_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_work_updated_by();
    }

    /**
     * get_work_updated_date_by_id method is stand for get the value
     * ofwork_updated_date By id.
     *
     * @var timestamp work_updated_date
     */
    public function get_work_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_work_updated_date()));
    }

    /**
     * get_work_created_by_by_id method is stand for get the value ofwork_created_by By
     * id.
     *
     * @var int work_created_by
     */
    public function get_work_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_work_created_by();
    }

    /**
     * get_work_created_date_by_id method is stand for get the value
     * ofwork_created_date By id.
     *
     * @var timestamp work_created_date
     */
    public function get_work_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_work_created_date()));
    }


}
