<?php

class Application_Model_WorkStatusLogic extends Application_Model_WorkStatus
{
    
    public function fetchDataTableSelect($id) 
    {
        $columns = array('work_created_date', 'user_name', 'work_status', 'work_remarks');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_WorkStatusLogic(-1)), $columns);
        $where = $obj_data->get_where();
        $where->where('work_id = ?', $id);
        $where->from(array("l"=>$this->_name, "u"=>"asit_user"), 
                array("l.work_created_date", "u.user_name", 'l.work_status', 'l.work_remarks'));
        $where->join(array("u"=>"asit_user"),
                'l.work_created_by = u.id', array())
                ->setIntegrityCheck(false);
        $obj_data->set_where($where);
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        foreach($rows as $row)
        {
            $results[$i] = array(date('d-M-Y h:i:s A', strtotime($row->work_created_date)), $row->user_name, $row->work_status, $row->work_remarks);
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }
    
    
}

