<?php

class Dynasty_ActivityController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
        $this->_helper->layout()->setLayout('admin');
    }

    public function indexAction()
    {
        // action body
        if(Application_Model_RolePermissionLogic::isPermitted("Activity:Master")) {
            
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function jsonAction()
    {
        $this->_helper->layout()->disableLayout();
        $obj_activity = new Application_Model_ActivityLogic(-1);
        echo $obj_activity->fetchDataTableSelect();
    }

    public function addAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Activity:Add")) {
            $obj_form = new Application_Form_Activity();
            $this->view->form = $obj_form;
            $obj_activity = new Application_Model_Activity(-1);
            if($this->getRequest()->isPost()){
                $data=$this->getRequest()->getPost();
                if($obj_form->isValid($data)){
                    $user = new Application_Model_UserLogic(-1);
                    $obj_activity->set_activity_title($obj_form->activity_title->getValue());
                    $obj_activity->set_activity_desc($obj_form->activity_desc->getValue());
                    $obj_activity->set_activity_date(date('Y-m-d H:i:s', strtotime($obj_form->activity_date->getValue())));
                    $obj_activity->set_activity_url($obj_form->activity_url->getValue());
                    $obj_activity->set_activity_meta_key($obj_form->activity_meta_key->getValue());
                    $obj_activity->set_activity_meta_desc($obj_form->activity_meta_desc->getValue());
                    $obj_activity->set_activity_status($obj_form->activity_status->getValue());
                    $obj_activity->set_activity_updated_by($user->getLoggedInUserId());
                    $obj_activity->set_activity_created_by($user->getLoggedInUserId());
                    $obj_activity->save();
                    
                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "Activity Created Successfully!!!";
                    $this->_redirect("dynasty/activity/index");
                }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function editAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Activity:Edit")) {
            $id = $this->_getParam("id");
            $obj_form = new Application_Form_Activity();
            $obj_activity = new Application_Model_Activity($id);
            $obj_form->activity_title->setValue($obj_activity->get_activity_title());
            $obj_form->activity_meta_key->setValue($obj_activity->get_activity_meta_key());
            $obj_form->activity_desc->setValue($obj_activity->get_activity_desc());
            $obj_form->activity_date->setValue(date('d-M-Y', strtotime($obj_activity->get_activity_date())));
            $obj_form->activity_url->setValue($obj_activity->get_activity_url());
            $obj_form->activity_meta_desc->setValue($obj_activity->get_activity_meta_desc());
            $obj_form->activity_status->setValue($obj_activity->get_activity_status());
            $this->view->form = $obj_form;
            if($this->getRequest()->isPost()){
                $data=$this->getRequest()->getPost();
                if($obj_form->isValid($data)){
                    $user = new Application_Model_UserLogic(-1);
                    $obj_activity->set_activity_title($obj_form->activity_title->getValue());
                    $obj_activity->set_activity_desc($obj_form->activity_desc->getValue());
                    $obj_activity->set_activity_date(date('Y-m-d H:i:s', strtotime($obj_form->activity_date->getValue())));
                    $obj_activity->set_activity_url($obj_form->activity_url->getValue());
                    $obj_activity->set_activity_meta_key($obj_form->activity_meta_key->getValue());
                    $obj_activity->set_activity_meta_desc($obj_form->activity_meta_desc->getValue());
                    $obj_activity->set_activity_status($obj_form->activity_status->getValue());
                    $obj_activity->set_activity_updated_by($user->getLoggedInUserId());
                    $obj_activity->save();
                    
                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "Activity Updated Successfully!!!";
                    $this->_redirect("dynasty/activity/index");
                }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function deleteAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Activity:Delete")) {
            $id = $this->_getParam("id");
            $obj_activity = new Application_Model_Activity($id);
            $obj_activity->set_activity_status('D');
            $obj_activity->save();

            $sess = new Zend_Session_Namespace("msg");
            $sess->msg = "Activity Removed Successfully!!!";
            $this->_redirect("dynasty/activity/index");
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }


}
