<?php

class Dynasty_AlbumController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
        $this->_helper->layout()->setLayout('admin');
    }

    public function indexAction()
    {
        // action body
        if(Application_Model_RolePermissionLogic::isPermitted("Album:Master")) {
            
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function jsonAction()
    {
        $this->_helper->layout()->disableLayout();
        $obj_album = new Application_Model_AlbumLogic(-1);
        echo $obj_album->fetchDataTableSelect();
    }

    public function addAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Album:Add")) {
            $obj_form = new Application_Form_Album();
            $this->view->form = $obj_form;
            $obj_album = new Application_Model_Album(-1);
            if($this->getRequest()->isPost()){
                $data=$this->getRequest()->getPost();
                if($obj_form->isValid($data)){
                    $user = new Application_Model_UserLogic(-1);
                    $siteSess = new Zend_Session_Namespace('site');
                    $obj_album->set_album_title($obj_form->album_title->getValue());
                    $obj_album->set_album_desc($obj_form->album_desc->getValue());
                    $obj_album->set_album_type('B');
                    $obj_album->set_album_cover($obj_form->album_cover->getValue());
                    $obj_album->set_album_url($obj_form->album_url->getValue());
                    $obj_album->set_album_status($obj_form->album_status->getValue());
                    $obj_album->set_album_updated_by($user->getLoggedInUserId());
                    $obj_album->set_album_created_by($user->getLoggedInUserId());
                    $obj_album->save();
                    
                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "Album Created Successfully!!!";
                    $this->_redirect("dynasty/album/index");
                }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function editAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Album:Edit")) {
            $id = $this->_getParam("id");
            $obj_form = new Application_Form_Album();
            $obj_album = new Application_Model_Album($id);
            $obj_form->album_title->setValue($obj_album->get_album_title());
            $obj_form->album_desc->setValue($obj_album->get_album_desc());
            $obj_form->album_cover->setRequired(false);
            $obj_form->album_url->setValue($obj_album->get_album_url());
            $obj_form->album_status->setValue($obj_album->get_album_status());
            $this->view->form = $obj_form;
            if($this->getRequest()->isPost()){
                $data=$this->getRequest()->getPost();
                if($obj_form->isValid($data)){
                    $obj_album->set_album_title($obj_form->album_title->getValue());
                    $obj_album->set_album_desc($obj_form->album_desc->getValue());
                    if($obj_form->album_cover->getValue() != '' && count(explode('.', $obj_form->album_cover->getValue())) > 0) {
                        $obj_album->set_album_cover($obj_form->album_cover->getValue());
                    }
                    $obj_album->set_album_url($obj_form->album_url->getValue());
                    $obj_album->set_album_status($obj_form->album_status->getValue());
                    $obj_album->save();
                    
                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "Album Updated Successfully!!!";
                    $this->_redirect("dynasty/album/index");
                }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function deleteAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Album:Delete")) {
            $id = $this->_getParam("id");
            $obj_album = new Application_Model_AlbumLogic($id);
            $obj_album->set_album_status('D');
            $obj_album->save();
            
            $sess = new Zend_Session_Namespace("msg");
            $sess->msg = "Albums Removed Successfully!!!";
            $this->_redirect("dynasty/album/index");
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    

}

