<?php

class Dynasty_AlumniController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
        $this->_helper->layout()->setLayout('admin');
    }

    public function indexAction()
    {
        // action body
        if(Application_Model_RolePermissionLogic::isPermitted("Alumni:Master")) {
            
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function jsonAction()
    {
        $this->_helper->layout()->disableLayout();
        $obj_alumni = new Application_Model_AlumniLogic(-1);
        echo $obj_alumni->fetchDataTableSelect();
    }
    
    public function viewAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Alumni:View")) {
            $enc = new Application_Model_Util_Encrypt();
            $id = $enc->showHiddenContent($this->_getParam('id'));
            
            $obj_alumni = new Application_Model_AlumniLogic($id);
            $this->view->alumni = $obj_alumni;
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function deleteAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Alumni:Delete")) {
            $enc = new Application_Model_Util_Encrypt();
            $id = $enc->showHiddenContent($this->_getParam('id'));
            $obj_user = new Application_Model_UserLogic(-1);
            
            $obj_tc = new Application_Model_TcLogic($id);
            $obj_tc->set_tc_status('D');
            $obj_tc->set_tc_updated_by($obj_user->getLoggedInUserId());
            $obj_tc->save();

            $sess = new Zend_Session_Namespace("msg");
            $sess->msg = "Tc Removed Successfully!!!";
            $this->_redirect("dynasty/tc/index");
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }


}

