<?php

class Dynasty_BlogController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
        $this->_helper->layout()->setLayout('admin');
    }

    public function indexAction()
    {
        // action body
        if(Application_Model_RolePermissionLogic::isPermitted("Blog:Master")) {
            
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function jsonAction()
    {
        $this->_helper->layout()->disableLayout();
        $obj_blog = new Application_Model_BlogLogic(-1);
        echo $obj_blog->fetchDataTableSelect();
    }

    public function addAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Blog:Add")) {
            $obj_form = new Application_Form_Blog();
            $this->view->form = $obj_form;
            $obj_asitblog = new Application_Model_BlogLogic(-1);
            if($this->getRequest()->isPost()){
                $data=$this->getRequest()->getPost();
                if($obj_form->isValid($data)){
                    $user = new Application_Model_UserLogic(-1);
                    $obj_asitblog->set_blog_title($obj_form->blog_title->getValue());
                    $obj_asitblog->set_blog_image($obj_form->blog_image->getValue());
                    $obj_asitblog->set_blog_category($obj_form->blog_category->getValue());
                    $obj_asitblog->set_blog_short_desc($obj_form->blog_short_desc->getValue());
                    $obj_asitblog->set_blog_desc($obj_form->blog_desc->getValue());
                    $obj_asitblog->set_blog_url($obj_asitblog->generateBlogUrl($obj_form->blog_title->getValue()));
                    $obj_asitblog->set_blog_meta_key($obj_form->blog_meta_key->getValue());
                    $obj_asitblog->set_blog_meta_desc($obj_form->blog_meta_desc->getValue());
                    $obj_asitblog->set_blog_status($obj_form->blog_status->getValue());
                    $obj_asitblog->set_blog_updated_by($user->getLoggedInUserId());
                    $obj_asitblog->set_blog_created_by($user->getLoggedInUserId());
                    $obj_asitblog->save();
                    
                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "Blog Created Successfully!!!";
                    $this->_redirect("dynasty/blog/index");
                }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function editAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Blog:Edit")) {
            $id = $this->_getParam("id");
            $obj_form = new Application_Form_Blog();
            $obj_asitblog = new Application_Model_Blog($id);
            $obj_form->blog_title->setValue($obj_asitblog->get_blog_title());
            $obj_form->blog_image->setRequired(false);
            $obj_form->blog_short_desc->setValue($obj_asitblog->get_blog_short_desc());
            $obj_form->blog_desc->setValue($obj_asitblog->get_blog_desc());
            $obj_form->blog_category->setValue($obj_asitblog->get_blog_category());
            $obj_form->blog_meta_key->setValue($obj_asitblog->get_blog_meta_key());
            $obj_form->blog_meta_desc->setValue($obj_asitblog->get_blog_meta_desc());
            $obj_form->blog_status->setValue($obj_asitblog->get_blog_status());
            $this->view->form = $obj_form;
            if($this->getRequest()->isPost()){
                $data=$this->getRequest()->getPost();
                if($obj_form->isValid($data)){
                    $user = new Application_Model_UserLogic(-1);
                    $obj_asitblog->set_blog_title($obj_form->blog_title->getValue());
                    $obj_asitblog->set_blog_category($obj_form->blog_category->getValue());
                    if(count(explode('.', $obj_form->blog_image->getValue())) > 1) {
                        $obj_asitblog->set_blog_image($obj_form->blog_image->getValue());
                    }
                    $obj_asitblog->set_blog_short_desc($obj_form->blog_short_desc->getValue());
                    $obj_asitblog->set_blog_desc($obj_form->blog_desc->getValue());
                    $obj_asitblog->set_blog_meta_key($obj_form->blog_meta_key->getValue());
                    $obj_asitblog->set_blog_meta_desc($obj_form->blog_meta_desc->getValue());
                    $obj_asitblog->set_blog_status($obj_form->blog_status->getValue());
                    $obj_asitblog->set_blog_updated_by($user->getLoggedInUserId());
                    $obj_asitblog->save();
                    
                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "Blog Updated Successfully!!!";
                    $this->_redirect("dynasty/blog/index");
                }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function deleteAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Blog:Delete")) {
            $id = $this->_getParam("id");
            $obj_asitblog = new Application_Model_BlogLogic($id);
            $obj_asitblog->set_blog_status('D');
            $obj_asitblog->save();

            $sess = new Zend_Session_Namespace("msg");
            $sess->msg = "Blog Removed Successfully!!!";
            $this->_redirect("dynasty/blog/index");
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }


}
