<?php

class Dynasty_CategoryController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
        $this->_helper->layout()->setLayout('admin');
    }

    public function indexAction()
    {
        // action body
        if(Application_Model_RolePermissionLogic::isPermitted("Category:Master")) {
            $this->view->type = $type = $this->_getParam('type');
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function jsonAction()
    {
        $this->_helper->layout()->disableLayout();
        $obj_cat = new Application_Model_CategoryLogic(-1);
        echo $obj_cat->fetchDataTableSelect();
    }

    public function addAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Category:Add")) {
            $type = $this->_getParam('type');
            $obj_form = new Application_Form_Category(array('type'=>$type));
            $this->view->form = $obj_form;
            $obj_asitcategory = new Application_Model_Category(-1);
            if($this->getRequest()->isPost()){
                $data=$this->getRequest()->getPost();
                if($obj_form->isValid($data)){
                    $user = new Application_Model_UserLogic(-1);
                    $obj_asitcategory->set_category_title($obj_form->category_title->getValue());
                    $obj_asitcategory->set_category_icon($obj_form->category_icon->getValue());
                    $obj_asitcategory->set_category_desc($obj_form->category_desc->getValue());
                    $obj_asitcategory->set_category_meta_key($obj_form->category_meta_key->getValue());
                    $obj_asitcategory->set_category_parent($obj_form->category_parent->getValue());
                    $obj_asitcategory->set_category_type($obj_form->category_type->getValue());
                    $obj_asitcategory->set_category_image($obj_form->category_image->getValue());
                    $obj_asitcategory->set_category_listings(0);
                    $obj_asitcategory->set_category_status($obj_form->category_status->getValue());
                    $obj_asitcategory->set_category_updated_by($user->getLoggedInUserId());
                    $obj_asitcategory->set_category_created_by($user->getLoggedInUserId());
                    $obj_asitcategory->save();

                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "Category Added Successfully!!!";
                    $this->_redirect("dynasty/category/index");
                }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function editAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Category:Edit")) {
            $id = $this->_getParam("id");
            $obj_asitcategory = new Application_Model_Category($id);
            $obj_form = new Application_Form_Category();
            $obj_form->category_title->setValue($obj_asitcategory->get_category_title());
            $obj_form->category_icon->setValue($obj_asitcategory->get_category_icon());
            $obj_form->category_desc->setValue($obj_asitcategory->get_category_desc());
            $obj_form->category_meta_key->setValue($obj_asitcategory->get_category_meta_key());
            $obj_form->category_parent->setValue($obj_asitcategory->get_category_parent());
            $obj_form->category_type->setValue($obj_asitcategory->get_category_type());
            $obj_form->category_type->setRequired(false);
            $obj_form->category_status->setValue($obj_asitcategory->get_category_status());
            $this->view->form = $obj_form;
            if($this->getRequest()->isPost()){
                $data=$this->getRequest()->getPost();
                if($obj_form->isValid($data)){
                    $user = new Application_Model_UserLogic(-1);
                    $obj_asitcategory->set_category_title($obj_form->category_title->getValue());
                    $obj_asitcategory->set_category_icon($obj_form->category_icon->getValue());
                    $obj_asitcategory->set_category_desc($obj_form->category_desc->getValue());
                    $obj_asitcategory->set_category_meta_key($obj_form->category_meta_key->getValue());
                    if(count(explode('.', $obj_form->category_image->getValue())) > 1) {
                        $obj_asitcategory->set_category_image($obj_form->category_image->getValue());
                    }
                    $obj_asitcategory->set_category_parent($obj_form->category_parent->getValue());
                    $obj_asitcategory->set_category_type($obj_form->category_type->getValue());
                    $obj_asitcategory->set_category_status($obj_form->category_status->getValue());
                    $obj_asitcategory->set_category_updated_by($user->getLoggedInUserId());
                    $obj_asitcategory->save();

                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "category Updated Successfully!!!";
                    $this->_redirect("dynasty/category/index");
                }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function deleteAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Category:Delete")) {
            $id = $this->_getParam("id");
            $obj_asitcategory = new Application_Model_Category($id);
            $obj_asitcategory->set_category_status('D');
            $obj_asitcategory->save();

            $sess = new Zend_Session_Namespace("msg");
            $sess->msg = "Category Removed Successfully!!!";
            $this->_redirect("dynasty/category/index");
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }


}
