<?php

class Dynasty_CircularController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
        $this->_helper->layout()->setLayout('admin');
    }

    public function indexAction()
    {
        // action body
        if(Application_Model_RolePermissionLogic::isPermitted("Circular:Master")) {
            
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function jsonAction()
    {
        $this->_helper->layout()->disableLayout();
        $obj_circular = new Application_Model_CircularLogic(-1);
        echo $obj_circular->fetchDataTableSelect();
    }

    public function addAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Circular:Add")) {
            $obj_form = new Application_Form_Circular();
            $this->view->form = $obj_form;
            $obj_circular = new Application_Model_Circular(-1);
            if($this->getRequest()->isPost()){
                $data=$this->getRequest()->getPost();
                if($obj_form->isValid($data)){
                    $user = new Application_Model_UserLogic(-1);
                    $obj_circular->set_circular_title($obj_form->circular_title->getValue());
                    $obj_circular->set_circular_desc($obj_form->circular_desc->getValue());
                    $obj_circular->set_circular_file($obj_form->circular_file->getValue());
                    $obj_circular->set_circular_status($obj_form->circular_status->getValue());
                    $obj_circular->set_circular_updated_by($user->getLoggedInUserId());
                    $obj_circular->set_circular_created_by($user->getLoggedInUserId());
                    $obj_circular->save();
                    
                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "Circular Created Successfully!!!";
                    $this->_redirect("dynasty/circular/index");
                }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function editAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Circular:Edit")) {
            $id = $this->_getParam("id");
            $obj_form = new Application_Form_Circular();
            $obj_circular = new Application_Model_Circular($id);
            $obj_form->circular_title->setValue($obj_circular->get_circular_title());
            $obj_form->circular_desc->setValue($obj_circular->get_circular_desc());
            $obj_form->circular_file->setRequired(false);
            $obj_form->circular_status->setValue($obj_circular->get_circular_status());
            $this->view->form = $obj_form;
            if($this->getRequest()->isPost()){
                $data=$this->getRequest()->getPost();
                if($obj_form->isValid($data)){
                    $user = new Application_Model_UserLogic(-1);
                    $obj_circular->set_circular_title($obj_form->circular_title->getValue());
                    $obj_circular->set_circular_desc($obj_form->circular_desc->getValue());
                    if($obj_form->circular_file->getValue() != '' && count(explode('.', $obj_form->circular_file->getValue())) > 0) {
                        $obj_circular->set_circular_file($obj_form->circular_file->getValue());
                    }
                    $obj_circular->set_circular_status($obj_form->circular_status->getValue());
                    $obj_circular->set_circular_updated_by($user->getLoggedInUserId());
                    $obj_circular->save();
                    
                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "Circular Updated Successfully!!!";
                    $this->_redirect("dynasty/circular/index");
                }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function deleteAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Circular:Delete")) {
            $id = $this->_getParam("id");
            $obj_circular = new Application_Model_Circular($id);
            $obj_circular->set_circular_status('D');
            $obj_circular->save();

            $sess = new Zend_Session_Namespace("msg");
            $sess->msg = "Circular Removed Successfully!!!";
            $this->_redirect("dynasty/circular/index");
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }


}
