<?php

class Dynasty_RoleController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
        $this->_helper->layout()->setLayout('admin');
    }

    public function indexAction()
    {
        // action body
        if(Application_Model_RolePermissionLogic::isPermitted("Role:Master")) {
            
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function jsonAction()
    {
        $this->_helper->layout()->disableLayout();
        $obj_role = new Application_Model_RoleLogic(-1);
        echo $obj_role->fetchDataTableSelect();
    }

    public function addAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Role:Add")) {
            $obj_form = new Application_Form_Role();
            $this->view->form = $obj_form;
            $obj_cloudcannyrole = new Application_Model_Role(-1);
            if($this->getRequest()->isPost()){
               $data=$this->getRequest()->getPost();
               if($obj_form->isValid($data)){
                 $obj_cloudcannyrole->set_role_title($obj_form->role_title->getValue());
                 $obj_cloudcannyrole->set_role_description($obj_form->role_description->getValue());
                 $obj_cloudcannyrole->set_role_is_admin(false);
                 $obj_cloudcannyrole->set_role_is_register(true);
                 $user = new Application_Model_UserLogic(-1);
                 $obj_cloudcannyrole->set_role_created_by($user->getLoggedInUser()->get_id());
                 $obj_cloudcannyrole->save();

                 $id = $obj_cloudcannyrole->getAdapter()->lastInsertId();
                 $obj_rper = new Application_Model_RolePermissionLogic(-1);

                 $permissions = $obj_form->permissions->getValue();
                 for($i = 0; $i < count($permissions); $i++)
                 {
                     $obj_rper->insertPermissionByRole($id, $permissions[$i], $user->getAdapter()->lastInsertId());
                 }

                 $cacheUtil = new Application_Model_Cache_Role();
                 $cacheUtil->roleCache($id);
                 
                 $sess = new Zend_Session_Namespace("msg");
                 $sess->msg = "Role Created Successfully!!!";
                 $this->_redirect("dynasty/role/index");
               }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function editAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Role:Edit")) {
            $enc = new Application_Model_Util_Encrypt();
            $id = $enc->showHiddenContent($this->_getParam("id"));
            $obj_form = new Application_Form_Role();
            $obj_cloudcannyrole = new Application_Model_Role($id);
            $obj_form->role_title->setValue($obj_cloudcannyrole->get_role_title());
            $obj_form->role_description->setValue($obj_cloudcannyrole->get_role_description());
            $obj_rper = new Application_Model_RolePermissionLogic(-1);
            $rolePermissions = $obj_rper->getPermissionsByRole($id);
            $obj_form->permissions->setValue($rolePermissions);
            $this->view->form = $obj_form;
            if($this->getRequest()->isPost()){
              $data=$this->getRequest()->getPost();
              if($obj_form->isValid($data)){
                 $obj_cloudcannyrole->set_role_title($obj_form->role_title->getValue());
                 $obj_cloudcannyrole->set_role_description($obj_form->role_description->getValue());
                 $obj_cloudcannyrole->save();

                 $obj_rper = new Application_Model_RolePermissionLogic(-1);
                 $obj_rper->deletePermissionByRole($id);
                 $user = new Application_Model_UserLogic(-1);
                 $permissions = $obj_form->permissions->getValue();

                 for($i = 0; $i < count($permissions); $i++)
                 {
                     $obj_rper->insertPermissionByRole($id, $permissions[$i], $user->getLoggedInUser()->get_id());
                 }

                 $cacheUtil = new Application_Model_Cache_Role();
                 $cacheUtil->resetRoleCache($id);
                 $cacheUtil->roleCache($id);
                 $cacheUtil->resetNavCache($id);
                 
                 $sess = new Zend_Session_Namespace("msg");
                 $sess->msg = "Role Updated Successfully!!!";
                 $this->_redirect("dynasty/role/index");
              }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function deleteAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Role:Delete")) {
            $enc = new Application_Model_Util_Encrypt();
            $id = $enc->showHiddenContent($this->_getParam('id'));
            $obj_cloudcannyrole = new Application_Model_Role($id);
            $obj_rper = new Application_Model_RolePermissionLogic(-1);
            $obj_rper->deletePermissionByRole($id);
            $obj_cloudcannyrole->remove();

            $cacheUtil = new Application_Model_Cache_Role();
            $cacheUtil->resetRoleCache($id);
            $cacheUtil->resetNavCache($id);

            $sess = new Zend_Session_Namespace("msg");
            $sess->msg = "Role Removed Successfully!!!";
            $this->_redirect("dynasty/role/index");
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }


}

