<?php

class Dynasty_ConfigController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
        $this->_helper->layout()->setLayout('admin');
    }

    public function indexAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Config:Master")) {
            
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function jsonAction()
    {
        $this->_helper->layout()->disableLayout();
        $obj_role = new Application_Model_ConfigLogic(-1);
        echo $obj_role->fetchDataTableSelect();
    }

    public function addAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Config:Add")) {
            $obj_form = new Application_Form_Config();
            $this->view->form = $obj_form;
            $obj_cloudcannyconfig = new Application_Model_Config(-1);
            if($this->getRequest()->isPost()){
               $data=$this->getRequest()->getPost();
               if($obj_form->isValid($data)){
                 $obj_cloudcannyconfig->set_config_key($obj_form->config_key->getValue());
                 $obj_cloudcannyconfig->set_config_value($obj_form->config_value->getValue());
                 $obj_cloudcannyconfig->set_config_serialize($obj_form->config_serialize->getValue());
                 $obj_cloudcannyconfig->save();
                 $cache = new Application_Model_Cache_Config();
                 $cache->resetConfigCache();
                 $cache->generateCache();

                 $sess = new Zend_Session_Namespace("msg");
                 $sess->msg = "Configuration Created Successfully!!!";
                 $this->_redirect("dynasty/config/index");
               }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function editAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Config:Edit")) {
            $enc = new Application_Model_Util_Encrypt();
            $id = $enc->showHiddenContent($this->_getParam("id"));
            $obj_form = new Application_Form_Config();
            $obj_cloudcannyconfig = new Application_Model_Config($id);
            $obj_form->config_key->setValue($obj_cloudcannyconfig->get_config_key());
            if(!Application_Model_RolePermissionLogic::isPermitted("Admin:Config:Add")) {
                $obj_form->config_key->setAttrib('readOnly', 'readOnly');
            }
            $obj_form->config_value->setValue($obj_cloudcannyconfig->get_config_value());
            $obj_form->config_serialize->setValue($obj_cloudcannyconfig->get_config_serialize());
            $this->view->form = $obj_form;
            if($this->getRequest()->isPost()){
              $data=$this->getRequest()->getPost();
              if($obj_form->isValid($data)){
                 $obj_cloudcannyconfig->set_config_key($obj_form->config_key->getValue());
                 $obj_cloudcannyconfig->set_config_value($obj_form->config_value->getValue());
                 $obj_cloudcannyconfig->set_config_serialize($obj_form->config_serialize->getValue());
                 $obj_cloudcannyconfig->save();
                 $cache = new Application_Model_Cache_Config();
                 $cache->resetConfigCache();
                 $cache->generateCache();

                 $sess = new Zend_Session_Namespace("msg");
                 $sess->msg = "Configuration Updated Successfully!!!";
                 $this->_redirect("dynasty/config/index");
              }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function deleteAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Config:Delete")) {
            $enc = new Application_Model_Util_Encrypt();
            $id = $enc->showHiddenContent($this->_getParam("id"));
            $obj_cloudcannyconfig = new Application_Model_Config($id);
            $obj_cloudcannyconfig->remove();
            $cache = new Application_Model_Cache_Config();
            $cache->resetConfigCache();
            $cache->generateCache();

            $sess = new Zend_Session_Namespace("msg");
            $sess->msg = "Configuration Removed Successfully!!!";
            $this->_redirect("dynasty/config/index");
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
}

