<?php

class Dynasty_DownController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
        $this->_helper->layout()->setLayout('admin');
    }

    public function indexAction()
    {
        // action body
        if(Application_Model_RolePermissionLogic::isPermitted("Download:Master")) {
            
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function jsonAction()
    {
        $this->_helper->layout()->disableLayout();
        $obj_download = new Application_Model_DownloadLogic(-1);
        echo $obj_download->fetchDataTableSelect();
    }

    public function addAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Download:Add")) {
            $obj_form = new Application_Form_Download();
            $this->view->form = $obj_form;
            $obj_download = new Application_Model_Download(-1);
            if($this->getRequest()->isPost()){
                $data=$this->getRequest()->getPost();
                if($obj_form->isValid($data)){
                    $user = new Application_Model_UserLogic(-1);
                    $obj_download->set_download_title($obj_form->download_title->getValue());
                    $obj_download->set_download_desc($obj_form->download_desc->getValue());
                    $obj_download->set_download_file($obj_form->download_file->getValue());
                    $obj_download->set_download_status($obj_form->download_status->getValue());
                    $obj_download->set_download_updated_by($user->getLoggedInUserId());
                    $obj_download->set_download_created_by($user->getLoggedInUserId());
                    $obj_download->save();
                    
                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "Download Created Successfully!!!";
                    $this->_redirect("dynasty/down/index");
                }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function editAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Download:Edit")) {
            $id = $this->_getParam("id");
            $obj_form = new Application_Form_Download();
            $obj_download = new Application_Model_Download($id);
            $obj_form->download_title->setValue($obj_download->get_download_title());
            $obj_form->download_desc->setValue($obj_download->get_download_desc());
            $obj_form->download_file->setRequired(false);
            $obj_form->download_status->setValue($obj_download->get_download_status());
            $this->view->form = $obj_form;
            if($this->getRequest()->isPost()){
                $data=$this->getRequest()->getPost();
                if($obj_form->isValid($data)){
                    $user = new Application_Model_UserLogic(-1);
                    $obj_download->set_download_title($obj_form->download_title->getValue());
                    $obj_download->set_download_desc($obj_form->download_desc->getValue());
                    if($obj_form->download_file->getValue() != '' && count(explode('.', $obj_form->download_file->getValue())) > 0) {
                        $obj_download->set_download_file($obj_form->download_file->getValue());
                    }
                    $obj_download->set_download_status($obj_form->download_status->getValue());
                    $obj_download->set_download_updated_by($user->getLoggedInUserId());
                    $obj_download->save();
                    
                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "Download Updated Successfully!!!";
                    $this->_redirect("dynasty/down/index");
                }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function deleteAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Download:Delete")) {
            $id = $this->_getParam("id");
            $obj_download = new Application_Model_Download($id);
            $obj_download->set_download_status('D');
            $obj_download->save();

            $sess = new Zend_Session_Namespace("msg");
            $sess->msg = "Download Removed Successfully!!!";
            $this->_redirect("dynasty/down/index");
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }


}
