<?php

class Dynasty_DownloadController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
        $this->_helper->layout->disableLayout();
        $this->_helper->viewRenderer->setNoRender(true);
        
        $auth = Zend_Auth::getInstance(); 
        if(!$auth->hasIdentity()){ 
           $sess = new Zend_Session_Namespace('msg');
           $sess->error = "You are not authorize person, Please login!";
           $this->_redirect("dynasty/index/index");
        }
    }

    public function indexAction()
    {
        // action body
        $options['nestSeparator'] = ':';
        //$config=new Application_Model_Config();
        $type='';
        $sub_type='';
        $sub_sub_type='';
        if($this->getRequest()->getParam('folder')!=null){
            $type=$this->getRequest()->getParam('folder');
        }

        if($this->getRequest()->getParam('sub_folder')!=null){
            $sub_type=$this->getRequest()->getParam('sub_folder');
        }
        if($this->getRequest()->getParam('sub_sub_folder')!=null){
            $sub_sub_type=$this->getRequest()->getParam('sub_sub_folder');
        }
        $fname=$this->getRequest()->getParam('filename');
        
        $this->getResponse()->setHeader('Cache-Control','max-age=290304000, public');
        
        $upload_folder = Application_Model_Cache_Config::getConfig('UPLOAD_FOLDER_NAME');
        if($type!=''){
            $full_path = $upload_folder . '/' . $type. '/' . $fname;
            if($sub_type!=''){
                $full_path = $upload_folder . '/' . $type . '/' . $sub_type . '/' . $fname;                
            }
            if($sub_sub_type!=''){
                $full_path = $upload_folder . '/' . $type . '/' . $sub_type . '/' . $sub_sub_type . '/' . $fname;
            }
        }
        else
            $full_path = $upload_folder. '/' . $fname;
        
        $this->getResponse()->setHeader('Content-Type', mime_content_type($full_path));
        
        if(!file_exists($full_path)){
           $this->badAction($full_path);
        }
        readfile($full_path);
    }


    public function badAction($fullPath){
        $this->getResponse()->setHeader('Content-Type',mime_content_type ($fullPath));
        echo "hello";
    }

}

