<?php

class Dynasty_EmailController extends Zend_Controller_Action
{

    public function init()
    {
        $this->_helper->layout()->setLayout('admin');
    }
    
    public function indexAction()
    {
        // action body
        if(Application_Model_RolePermissionLogic::isPermitted("Email:Send")) {
            $obj_email = new Application_Model_EmailLogLogic(-1);
            $obj_form = new Application_Form_Email();
            if($this->getRequest()->isPost()){
               $data=$this->getRequest()->getPost();
               if($obj_form->isValid($data)){
                   $obj_user = new Application_Model_UserLogic(-1);
                   $toUsers = array();
                   if($obj_form->email_to->getValue() != null) {
                        $toUsers = explode(',', $obj_form->email_to->getValue());
                   }
                   $ccUsers = array();
                   if($obj_form->email_cc->getValue() != null) {
                        $ccUsers = explode(',', $obj_form->email_cc->getValue());
                   }
                   $bccUsers = array();
                   if($obj_form->email_bcc->getValue() != null) {
                        $bccUsers = explode(',', $obj_form->email_bcc->getValue());
                   }

                   $email_factory = new Application_Model_Email_Factory();
                   $email_factory->sendMultiEmail($obj_form->id->getValue(), $obj_form->email_subject->getValue(), $toUsers, $ccUsers, $bccUsers, $obj_form->email_content->getValue());

                   $sess = new Zend_Session_Namespace("msg");
                   $sess->msg = "Mail Send Successfully!!!";
                   $this->_redirect("dynasty/email");
               }
            }else {
                if($this->_getParam('id') != null) {
                    $this->view->id = $id = $this->_getParam('id');
                }else {
                    $this->view->id = $id = $obj_email->initiateBulkEmail();
                }
                $email = new Application_Model_EmailLog($id);
                $obj_form->id->setValue($id);
                $obj_form->email_to->setValue($email->get_log_email_to());
                $obj_form->email_cc->setValue($email->get_log_email_cc());
                $obj_form->email_bcc->setValue($email->get_log_email_bcc());
                $obj_form->email_subject->setValue($email->get_log_subject());
                $obj_form->email_content->setValue($email->get_log_body());
            }
            $this->view->form = $obj_form;
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function attachmentAction()
    {
        $this->_helper->layout()->disableLayout();
        $id = $this->_getParam('id');
        $obj_email_attach = new Application_Model_EmailAttachmentLogic(-1);
        $this->view->attachments = $obj_email_attach->getAttachmentsByEmail($id);
        $obj_form = new Application_Form_EmailAttachment();
        $obj_form->id->setValue($id);
        $this->view->form = $obj_form;
        if($this->getRequest()->isPost()) {
            $data = $this->getRequest()->getPost();
            if($obj_form->isValid($data)) {
                $obj_email_attach->set_email_id($obj_form->id->getValue());
                $obj_email_attach->set_attachment_path($obj_form->email_attachment->getValue());
                $obj_email_attach->save();
                
                $this->_redirect('dynasty/email/attachment/id/'.$obj_form->id->getValue());
            }
        }
    }
    
    public function selectAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Email:Send")) {
            if($this->getRequest()->isPost()) {
                $data = $this->getRequest()->getPost();
                $obj_email = new Application_Model_EmailLogLogic(-1);
                $email = new Application_Model_EmailLog($obj_email->initiateBulkEmail());
                $emails = array();
                $cat = $data['cat'];
                if($cat == 'S') {
                    $obj_user = new Application_Model_UserLogic(-1);
                    $role = $data['role'];
                    if($role != 0) {
                        foreach($obj_user->fetchActiveUsersByRole($role) as $user) {
                            if(filter_var($user->user_email, FILTER_VALIDATE_EMAIL)) {
                                array_push($emails, $user->user_email);
                            }
                        }
                    }else {
                        foreach($obj_user->fetchActiveUsers() as $user) {
                            if(filter_var($user->user_email, FILTER_VALIDATE_EMAIL)) {
                                array_push($emails, $user->user_email);
                            }
                        }
                    }
                }else {
                    $this->_redirect('dynasty/email/index');
                }
                $email->set_log_email_to(implode(', ', $emails));
                $email->save();
                $this->_redirect('dynasty/email/index/id/'.$email->get_id());
            }
        }
    }
   
    public function scheduleAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Email:Schedule:Master")) {
            
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function jsonAction()
    {
        $this->_helper->layout()->disableLayout();
        $obj_email = new Application_Model_EmailScheduleLogic(-1);
        echo $obj_email->fetchDataTableSelect();
    }
    
    public function addAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Email:Schedule:Manage")) {
            $obj_form = new Application_Form_EmailSchedule();
            $this->view->form = $obj_form;
            $obj_asitemailschedule = new Application_Model_EmailSchedule(-1);
            if($this->getRequest()->isPost()){
                $data=$this->getRequest()->getPost();
                if($obj_form->isValid($data)){
                    $obj_asitemailschedule->set_email_to($obj_form->email_to->getValue());
                    $obj_asitemailschedule->set_email_cc($obj_form->email_cc->getValue());
                    $obj_asitemailschedule->set_email_bcc($obj_form->email_bcc->getValue());
                    $obj_asitemailschedule->set_email_from(Application_Model_Cache_Config::getConfig("DEFAULT_SENDER_MAIL_ADDRESS"));
                    $obj_asitemailschedule->set_email_from_name(Application_Model_Cache_Config::getConfig("DEFAULT_SENDER_MAIL_NAME"));
                    $obj_asitemailschedule->set_email_schedule(date('Y-m-d H:i:s', strtotime($obj_form->email_date->getValue().' '.$obj_form->email_time->getValue())));
                    $obj_asitemailschedule->set_email_subject($obj_form->email_subject->getValue());
                    $obj_asitemailschedule->set_email_body($obj_form->email_body->getValue());
                    $obj_asitemailschedule->set_email_priority(0);
                    $obj_user = new Application_Model_UserLogic(-1);
                    $obj_asitemailschedule->set_email_updated_by($obj_user->getLoggedInUserId());
                    $obj_asitemailschedule->set_email_created_by($obj_user->getLoggedInUserId());
                    $obj_asitemailschedule->save();

                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "Email Created Successfully!!!";
                    $this->_redirect("dynasty/email/schedule");
                }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function editAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Email:Schedule:Manage")) {
            $id = $this->_getParam("id");
            $obj_form = new Application_Form_EmailSchedule();
            $obj_asitemailschedule = new Application_Model_EmailSchedule($id);
            $obj_form->email_to->setValue($obj_asitemailschedule->get_email_to());
            $obj_form->email_cc->setValue($obj_asitemailschedule->get_email_cc());
            $obj_form->email_bcc->setValue($obj_asitemailschedule->get_email_bcc());
            $obj_form->email_date->setValue(date('d-M-Y', strtotime($obj_asitemailschedule->get_email_schedule())));
            $obj_form->email_time->setValue(date('h:i A', strtotime($obj_asitemailschedule->get_email_schedule())));
            $obj_form->email_subject->setValue($obj_asitemailschedule->get_email_subject());
            $obj_form->email_body->setValue($obj_asitemailschedule->get_email_body());
            $this->view->form = $obj_form;
            if($this->getRequest()->isPost()){
                $data=$this->getRequest()->getPost();
                if($obj_form->isValid($data)){
                    $obj_asitemailschedule->set_email_to($obj_form->email_to->getValue());
                    $obj_asitemailschedule->set_email_cc($obj_form->email_cc->getValue());
                    $obj_asitemailschedule->set_email_bcc($obj_form->email_bcc->getValue());
                    $obj_asitemailschedule->set_email_schedule(date('Y-m-d H:i:s', strtotime($obj_form->email_date->getValue().' '.$obj_form->email_time->getValue())));
                    $obj_asitemailschedule->set_email_subject($obj_form->email_subject->getValue());
                    $obj_asitemailschedule->set_email_body($obj_form->email_body->getValue());
                    $obj_user = new Application_Model_UserLogic(-1);
                    $obj_asitemailschedule->set_email_updated_by($obj_user->getLoggedInUserId());
                    $obj_asitemailschedule->save();

                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "Email Updated Successfully!!!";
                    $this->_redirect("dynasty/email/schedule");
                }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function removeAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Email:Schedule:Delete")) {
            $id = $this->_getParam("id");
            $obj_asitemailschedule = new Application_Model_EmailSchedule($id);
            $obj_asitemailschedule->remove();

            $sess = new Zend_Session_Namespace("msg");
            $sess->msg = "Email Removed Successfully From Scheduled Master!!!";
            $this->_redirect("dynasty/email/schedule");
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
   
}

