<?php

class Dynasty_EventsController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
        $this->_helper->layout()->setLayout('admin');
    }

    public function indexAction()
    {
        // action body
        if(Application_Model_RolePermissionLogic::isPermitted("Events:Master")) {
            
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function jsonAction()
    {
        $this->_helper->layout()->disableLayout();
        $obj_event = new Application_Model_EventsLogic(-1);
        echo $obj_event->fetchDataTableSelect();
    }

    public function addAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Events:Add")) {
            $obj_form = new Application_Form_Events();
            $this->view->form = $obj_form;
            $obj_events = new Application_Model_Events(-1);
            if($this->getRequest()->isPost()){
                $data=$this->getRequest()->getPost();
                if($obj_form->isValid($data)){
                    $user = new Application_Model_UserLogic(-1);
                    $obj_events->set_event_title($obj_form->event_title->getValue());
                    $obj_events->set_event_intro_text($obj_form->event_intro_text->getValue());
                    $obj_events->set_event_desc($obj_form->event_desc->getValue());
                    $obj_events->set_event_start(date('Y-m-d H:i:s', strtotime($obj_form->event_start->getValue())));
                    $obj_events->set_event_end(date('Y-m-d H:i:s', strtotime($obj_form->event_end->getValue())));
                    $obj_events->set_event_url($obj_form->event_url->getValue());
                    $obj_events->set_event_color($obj_form->event_color->getValue());
                    $obj_events->set_event_status($obj_form->event_status->getValue());
                    $obj_events->set_event_updated_by($user->getLoggedInUserId());
                    $obj_events->set_event_created_by($user->getLoggedInUserId());
                    $obj_events->save();
                    
                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "Event Created Successfully!!!";
                    $this->_redirect("dynasty/events/index");
                }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function editAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Events:Edit")) {
            $id = $this->_getParam("id");
            $obj_form = new Application_Form_Events();
            $obj_events = new Application_Model_Events($id);
            $obj_form->event_title->setValue($obj_events->get_event_title());
            $obj_form->event_intro_text->setValue($obj_events->get_event_intro_text());
            $obj_form->event_desc->setValue($obj_events->get_event_desc());
            $obj_form->event_start->setValue(date('d-M-Y', strtotime($obj_events->get_event_start())));
            $obj_form->event_end->setValue(date('d-M-Y', strtotime($obj_events->get_event_end())));
            $obj_form->event_url->setValue($obj_events->get_event_url());
            $obj_form->event_color->setValue($obj_events->get_event_color());
            $obj_form->event_status->setValue($obj_events->get_event_status());
            $this->view->form = $obj_form;
            if($this->getRequest()->isPost()){
                $data=$this->getRequest()->getPost();
                if($obj_form->isValid($data)){
                    $user = new Application_Model_UserLogic(-1);
                    $obj_events->set_event_title($obj_form->event_title->getValue());
                    $obj_events->set_event_intro_text($obj_form->event_intro_text->getValue());
                    $obj_events->set_event_desc($obj_form->event_desc->getValue());
                    $obj_events->set_event_start(date('Y-m-d H:i:s', strtotime($obj_form->event_start->getValue())));
                    $obj_events->set_event_end(date('Y-m-d H:i:s', strtotime($obj_form->event_end->getValue())));
                    $obj_events->set_event_url($obj_form->event_url->getValue());
                    $obj_events->set_event_color($obj_form->event_color->getValue());
                    $obj_events->set_event_status($obj_form->event_status->getValue());
                    $obj_events->set_event_updated_by($user->getLoggedInUserId());
                    $obj_events->save();
                    
                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "Event Updated Successfully!!!";
                    $this->_redirect("dynasty/events/index");
                }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function deleteAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Events:Delete")) {
            $id = $this->_getParam("id");
            $obj_events = new Application_Model_Events($id);
            $obj_events->set_event_status('D');
            $obj_events->save();

            $sess = new Zend_Session_Namespace("msg");
            $sess->msg = "Event Removed Successfully!!!";
            $this->_redirect("dynasty/events/index");
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }


}
