<?php

class Dynasty_HomeworkController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
        $this->_helper->layout()->setLayout('admin');
    }

    public function indexAction()
    {
        // action body
        if(Application_Model_RolePermissionLogic::isPermitted("Homework:Master")) {
            
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function jsonAction()
    {
        $this->_helper->layout()->disableLayout();
        $obj_hw = new Application_Model_HomeworkLogic(-1);
        echo $obj_hw->fetchDataTableSelect();
    }

    public function addAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Homework:Add")) {
            $obj_form = new Application_Form_Homework();
            $this->view->form = $obj_form;
            $obj_asithomework = new Application_Model_Homework(-1);
            if($this->getRequest()->isPost()){
                $data=$this->getRequest()->getPost();
                if($obj_form->isValid($data)){
                    $obj_asithomework->set_hw_title($obj_form->hw_title->getValue());
                    $obj_asithomework->set_hw_class($obj_form->hw_class->getValue());
                    $obj_asithomework->set_hw_file($obj_form->hw_file->getValue());
                    $obj_asithomework->set_hw_status('A');
                    $obj_user = new Application_Model_UserLogic(-1);
                    $obj_asithomework->set_hw_updated_by($obj_user->getLoggedInUserId());
                    $obj_asithomework->set_hw_created_by($obj_user->getLoggedInUserId());
                    $obj_asithomework->save();

                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "Homework Created Successfully!!!";
                    $this->_redirect("dynasty/homework/index");
                }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function editAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Homework:Edit")) {
            $enc = new Application_Model_Util_Encrypt();
            $id = $enc->showHiddenContent($this->_getParam("id"));
            $obj_form = new Application_Form_Homework();
            $obj_asithomework = new Application_Model_Homework($id);
            $obj_form->hw_title->setValue($obj_asithomework->get_hw_title());
            $obj_form->hw_class->setValue($obj_asithomework->get_hw_class());
            $obj_form->hw_file->setRequired(false);
            $this->view->form = $obj_form;
            if($this->getRequest()->isPost()){
                $data=$this->getRequest()->getPost();
                if($obj_form->isValid($data)){
                    $obj_asithomework->set_hw_title($obj_form->hw_title->getValue());
                    $obj_asithomework->set_hw_class($obj_form->hw_class->getValue());
                    if(count(explode('.', $obj_form->hw_file->getValue())) > 1) {
                        $obj_asithomework->set_hw_file($obj_form->hw_file->getValue());
                    }
                    $obj_user = new Application_Model_UserLogic(-1);
                    $obj_asithomework->set_hw_updated_by($obj_user->getLoggedInUserId());
                    $obj_asithomework->save();

                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "Homework Updated Successfully!!!";
                    $this->_redirect("dynasty/homework/index");
                }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function deleteAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Homework:Delete")) {
            $enc = new Application_Model_Util_Encrypt();
            $id = $enc->showHiddenContent($this->_getParam('id'));
            $obj_user = new Application_Model_UserLogic(-1);
            
            $obj_hw = new Application_Model_HomeworkLogic($id);
            $obj_hw->set_hw_status('D');
            $obj_hw->set_hw_updated_by($obj_user->getLoggedInUserId());
            $obj_hw->save();

            $sess = new Zend_Session_Namespace("msg");
            $sess->msg = "Homework Removed Successfully!!!";
            $this->_redirect("dynasty/homework/index");
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }


}

