<?php

class Dynasty_ImageController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
        $this->_helper->layout()->setLayout('admin');
    }

    public function indexAction()
    {
        // action body
        if(Application_Model_RolePermissionLogic::isPermitted("Album:Image:Master")) {
            $this->view->id = $id = $this->_getParam('id');
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function jsonAction()
    {
        $this->_helper->layout()->disableLayout();
        $this->view->id = $id = $this->_getParam('id');
        $obj_image = new Application_Model_ImageLogic(-1);
        echo $obj_image->fetchDataTableSelect($id);
    }

    public function addAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Album:Image:Add")) {
            $this->view->id = $id = $this->_getParam('id');
            $obj_form = new Application_Form_Image();
            $this->view->form = $obj_form;
            $obj_image = new Application_Model_Image(-1);
            if($this->getRequest()->isPost()){
                $data=$this->getRequest()->getPost();
                if($obj_form->isValid($data)){
                    $user = new Application_Model_UserLogic(-1);
                    $obj_image->set_image_title($obj_form->image_title->getValue());
                    $obj_image->set_image_desc($obj_form->image_desc->getValue());
                    $obj_image->set_image_album($id);
                    $obj_image->set_image_path($obj_form->image_path->getValue());
                    $obj_image->set_image_status($obj_form->image_status->getValue());
                    $obj_image->set_image_updated_by($user->getLoggedInUserId());
                    $obj_image->set_image_created_by($user->getLoggedInUserId());
                    $obj_image->save();
                    
                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "Image Added Successfully!!!";
                    $this->_redirect("dynasty/image/index/id/".$obj_image->get_image_album());
                }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function editAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Album:Image:Edit")) {
            $id = $this->_getParam("id");
            $obj_form = new Application_Form_Image();
            $obj_image = new Application_Model_Image($id);
            $this->view->id = $obj_image->get_image_album();
            $obj_form->image_title->setValue($obj_image->get_image_title());
            $obj_form->image_desc->setValue($obj_image->get_image_desc());
            $obj_form->image_path->setValue($obj_image->get_image_path());
            $obj_form->image_status->setValue($obj_image->get_image_status());
            $this->view->form = $obj_form;
            if($this->getRequest()->isPost()){
                $data=$this->getRequest()->getPost();
                if($obj_form->isValid($data)){
                    $user = new Application_Model_UserLogic(-1);
                    $obj_image->set_image_title($obj_form->image_title->getValue());
                    $obj_image->set_image_desc($obj_form->image_desc->getValue());
                    if(count(explode('.', $obj_form->image_path->getValue())) > 1) {
                        unlink(Application_Model_Cache_Config::getConfig('UPLOAD_FOLDER_NAME').'/image/'.$obj_image->get_image_path());
                        $obj_image->set_image_path($obj_form->image_path->getValue());
                    }
                    $obj_image->set_image_status($obj_form->image_status->getValue());
                    $obj_image->set_image_updated_by($user->getLoggedInUserId());
                    $obj_image->save();

                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "Image Updated Successfully!!!";
                    $this->_redirect("dynasty/image/index/id/".$obj_image->get_image_album());
                }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function deleteAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Album:Image:Delete")) {
            $id = $this->_getParam("id");
            $obj_image = new Application_Model_ImageLogic($id);
            $obj_image->set_image_status('D');
            $obj_image->save();
            
            $sess = new Zend_Session_Namespace("msg");
            $sess->msg = "Image Removed Successfully!!!";
            $this->_redirect("dynasty/image/index/id/".$obj_image->get_image_album());
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }


}
