<?php

class Dynasty_IndexController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
        $this->_helper->layout()->setLayout('admin');
    }

    public function indexAction()
    {
        $this->_helper->layout()->setLayout('login');
        
    }

    public function loginAction()
    {
        if($this->getRequest()->isPost()){
            $data = $this->getRequest()->getPost();
            $uname = $this->_getParam('user_id');
            $paswd = $this->_getParam('user_password');
            $obj_auth = new Application_Model_UserLogic(-1);
            $check = $obj_auth->is_user_authenticated($uname, $paswd);
            if($check){
                $obj_user = new Application_Model_UserLogic(-1);
                $logginUser = $obj_user->getLoggedInUser();
                $user = ($logginUser != null) ? new Application_Model_UserLogic($logginUser->get_id()) : null;
                Zend_Debug::dump($user);
                if($user->get_user_status() == 'B' || $user->get_user_role() == Application_Model_Cache_Config::getConfig("SITE_USER_ROLE")) {
                    $obj_user->logout();
                    $sess = new Zend_Session_Namespace('msg');
                    $sess->error = "Your account has been blocked. Please contact to administrator.";
                    $this->_redirect('dynasty/index');
                }
                else {
                    $sess = new Zend_Session_Namespace('msg');
                    $sess->msg = "You have successfully logged in.";
                    $this->_redirect('dynasty/dashboard');
                }
            }
            else{
                $sess = new Zend_Session_Namespace('msg');
                $sess->error = "Wrong User ID or Password, Please Reenter!".$uname.$paswd;
                $this->_redirect('dynasty/index');
            }
        }
        else {
            $sess = new Zend_Session_Namespace('msg');
            $sess->error = "Please enter valid data!";
            $this->_redirect('dynasty/index');
        }
    }
    
    public function forgetAction() 
    {
        $this->_helper->layout()->disableLayout();
        if($this->getRequest()->isPost()){
            $data = $this->getRequest()->getPost();
            $uname = $this->_getParam('user_id');
            $paswd = $this->_getParam('user_password');
            $repaswd = $this->_getParam('user_repassword');
            $otp = $this->_getParam('user_otp');
            $usess = new Zend_Session_Namespace('user');
            $sess = new Zend_Session_Namespace('msg');
            if($otp == $usess->user_otp) {
                $obj_user = new Application_Model_UserLogic(-1);
                $resetUser = $obj_user->getUserByUserId($uname);
                if($resetUser->get_user_status() == 'B') {
                    $sess->error = "Your account has been blocked. Please contact to administrator.";
                    $this->_redirect('dynasty/index/forget');
                }
                else if($paswd != $repaswd) {
                    $sess->error = "Sorry Password and Re Password does not match.";
                }
                else {
                    $resetUser->set_user_password(sha1($paswd));
                    $resetUser->save();
                    $sess->msg = "You have successfully reset the password.";
                    $this->_redirect('dynasty/index');
                }
            }
            else{
                $sess = new Zend_Session_Namespace('msg');
                $sess->error = "Sorry, OTP does not match!";
                $this->_redirect('dynasty/index/forget');
            }
        }
        
    }
    
    public function logoutAction()
    {
        $auth = Zend_Auth::getInstance(); 
        if(!$auth->hasIdentity()){ 
           $sess = new Zend_Session_Namespace('msg');
           $sess->error = "You session already expired, Please login!";
           $this->_redirect("dynasty/index");
        }
        $sess = new Zend_Session_Namespace('user');
        unset($sess->id);
        unset($sess->user_id);
        Zend_Session::namespaceUnset('user');
        $auth->clearIdentity();
        $sess = new Zend_Session_Namespace('msg');
        $sess->msg = "You have successfully logout.";
        $this->_redirect('dynasty/index');
    }

    public function chpwdAction()
    {
        $auth = Zend_Auth::getInstance(); 
        if($auth->hasIdentity()){ 
            $chpwdForm = new Application_Form_Chpwd();
            $this->view->form = $chpwdForm;
            if($this->getRequest()->isPost()){
                $data=$this->getRequest()->getPost();    
                if($chpwdForm->isValid($data)){
                    $iden = new Zend_Session_Namespace('user');
                    $obj_login = new Application_Model_User($iden->id);
                    $cred = $obj_login->get_user_password();
                    $oldpwd = $chpwdForm->old_pwd->getValue();
                    $newpwd = $chpwdForm->new_pwd->getValue();
                    $repwd = $chpwdForm->re_new_pwd->getValue();
                    if($cred == sha1($oldpwd)){
                        if($newpwd == $repwd){
                            $mpwd = sha1($newpwd);
                            $obj_login->set_user_password($mpwd);
                            $obj_login->save();
                            $sess = new Zend_Session_Namespace('msg');
                            $sess->msg = "You Have Successfully Change Your Password!!!";
                            $this->_redirect('dynasty/index/chpwd');
                        }
                        else{
                            $sess = new Zend_Session_Namespace('msg');
                            $sess->error = "Your Password Not Match!!!";
                            $this->_redirect('dynasty/index/chpwd');
                        }
                    }
                    else{
                        $sess = new Zend_Session_Namespace('msg');
                        $sess->error = "You Enter Wrong Old Password!!!";
                        $this->_redirect('dynasty/index/chpwd');
                    }
                }    
            }
        } 
        else { 
           $sess = new Zend_Session_Namespace('msg');
           $sess->error = "You are not authorize person, Please login!";
           $this->_redirect("dynasty/index/index");
        }
    }
    
}

