<?php

class Dynasty_LibraryController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
        $this->_helper->layout()->setLayout('admin');
    }

    public function indexAction()
    {
        // action body
        if(Application_Model_RolePermissionLogic::isPermitted("Library:Master")) {
            
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function jsonAction()
    {
        $this->_helper->layout()->disableLayout();
        $obj_library = new Application_Model_LibraryLogic(-1);
        echo $obj_library->fetchDataTableSelect();
    }

    public function addAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Library:Master")) {
            $obj_form = new Application_Form_Library();
            $this->view->form = $obj_form;
            $obj_asitlibrary = new Application_Model_LibraryLogic(-1);
            if($this->getRequest()->isPost()){
               $data=$this->getRequest()->getPost();
               if($obj_form->isValid($data)){
                 $user = new Application_Model_UserLogic(-1);   
                 $obj_asitlibrary->set_library_title($obj_form->library_title->getValue());
                 $obj_asitlibrary->set_library_category($obj_form->library_category->getValue());
                 $obj_asitlibrary->set_library_desc($obj_form->library_desc->getValue());
                 $obj_asitlibrary->set_library_file($obj_form->library_file->getValue());
                 $obj_asitlibrary->set_library_visibility($obj_form->library_visibility->getValue());
                 $obj_asitlibrary->set_library_status($obj_form->library_status->getValue());
                 $obj_asitlibrary->set_library_updated_by($user->getLoggedInUserId());
                 $obj_asitlibrary->set_library_created_by($user->getLoggedInUserId());
                 $obj_asitlibrary->save();

                 $sess = new Zend_Session_Namespace("msg");
                 $sess->msg = "Record Created Successfully!!!";
                 $this->_redirect("dynasty/library/index");
               }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function editAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Library:Master")) {
            $id = $this->_getParam("id");
            $obj_form = new Application_Form_Library();
            $obj_asitlibrary = new Application_Model_LibraryLogic($id);
            $obj_cat = new Application_Model_CategoryLogic($obj_asitlibrary->get_library_category());
            $obj_form->library_title->setValue($obj_asitlibrary->get_library_title());
            $obj_form->parent_cat->setValue($obj_cat->get_category_parent());
            foreach($obj_cat->getSubCategory($obj_cat->get_category_parent()) as $cat) {
                $obj_form->library_category->addMultiOption($cat->id, $cat->category_title);
            }
            $obj_form->library_category->setValue($obj_cat->get_id());
            $obj_form->library_desc->setValue($obj_asitlibrary->get_library_desc());
            $obj_form->library_file->setValue($obj_asitlibrary->get_library_file());
            $obj_form->library_file->setRequired(false);
            $obj_form->library_file->setDescription('Please select file only if you want to change the file otherwise leave it.');
            $obj_form->library_visibility->setValue($obj_asitlibrary->get_library_visibility());
            $obj_form->library_status->setValue($obj_asitlibrary->get_library_status());
            $this->view->form = $obj_form;
            if($this->getRequest()->isPost()){
              $data=$this->getRequest()->getPost();
              if($obj_form->isValid($data)){
                 $user = new Application_Model_UserLogic(-1); 
                 $obj_asitlibrary->set_library_title($obj_form->library_title->getValue());
                 $obj_asitlibrary->set_library_category($obj_form->library_category->getValue());
                 $obj_asitlibrary->set_library_desc($obj_form->library_desc->getValue());
                 if($obj_form->library_file->getValue() != '' && count(explode('.', $obj_form->library_file->getValue())) > 0) {
                    $obj_asitlibrary->set_library_file($obj_form->library_file->getValue());
                 }
                 $obj_asitlibrary->set_library_visibility($obj_form->library_visibility->getValue());
                 $obj_asitlibrary->set_library_status($obj_form->library_status->getValue());
                 $obj_asitlibrary->set_library_updated_by($user->getLoggedInUserId());
                 $obj_asitlibrary->save();

                 $sess = new Zend_Session_Namespace("msg");
                 $sess->msg = "Record Updated Successfully!!!";
                 $this->_redirect("dynasty/library/index");
              }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function deleteAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Library:Delete")) {
            $id = $this->_getParam("id");
            $obj_asitlibrary = new Application_Model_LibraryLogic($id);
            $obj_asitlibrary->set_library_status('D');
            $obj_asitlibrary->save();

            $sess = new Zend_Session_Namespace("msg");
            $sess->msg = "Record Removed Successfully!!!";
            $this->_redirect("dynasty/library/index");
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    

}

