<?php

class Dynasty_ListController extends Zend_Controller_Action {

    public function init() {
        /* Initialize action controller here */
        $this->_helper->layout()->setLayout('admin');
    }

    public function indexAction() {
        // action body
        if (Application_Model_RolePermissionLogic::isPermitted("List:Master")) {
            
        } else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function jsonAction() {
        $this->_helper->layout()->disableLayout();
        $obj_list = new Application_Model_ListLogic(-1);
        echo $obj_list->fetchDataTableSelect();
    }

    public function addAction() {
        if (Application_Model_RolePermissionLogic::isPermitted("List:Add")) {
            $obj_form = new Application_Form_List();
            $this->view->form = $obj_form;
            $obj_asitlist = new Application_Model_ListLogic(-1);
            if ($this->getRequest()->isPost()) {
                $data = $this->getRequest()->getPost();
                if ($obj_form->isValid($data)) {
                    $user = new Application_Model_UserLogic(-1);
                    $obj_asitlist->set_list_title($obj_form->list_title->getValue());
                    $obj_asitlist->set_list_category($obj_form->list_category->getValue());
                    $obj_asitlist->set_list_short_desc($obj_form->list_short_desc->getValue());
                    $obj_asitlist->set_list_desc($obj_form->list_desc->getValue());
                    $obj_asitlist->set_list_image($obj_form->list_image->getValue());
                    $obj_asitlist->set_list_tag_line($obj_form->list_tag_line->getValue());
                    $obj_asitlist->set_list_address($obj_form->list_address->getValue());
                    $obj_asitlist->set_list_city($obj_form->list_city->getValue());
                    $obj_asitlist->set_list_phone($obj_form->list_phone->getValue());
                    $obj_asitlist->set_list_email($obj_form->list_email->getValue());
                    $obj_asitlist->set_list_website($obj_form->list_website->getValue());
                    $obj_asitlist->set_list_url($obj_asitlist->generateListUrl($obj_form->list_title->getValue()));
                    $obj_asitlist->set_list_type($obj_form->list_type->getValue());
                    $obj_asitlist->set_list_status('A');
                    $obj_asitlist->set_list_review_score(0);
                    $obj_asitlist->set_list_review_total(0);
                    $obj_asitlist->set_list_visitors(0);
                    $obj_asitlist->set_list_rate_ambience($obj_form->list_rate_ambience->getValue());
                    $obj_asitlist->set_list_rate_food($obj_form->list_rate_food->getValue());
                    $obj_asitlist->set_list_rate_service($obj_form->list_rate_service->getValue());
                    $obj_asitlist->set_list_rate_value($obj_form->list_rate_value->getValue());
                    $obj_asitlist->set_list_updated_by($user->getLoggedInUserId());
                    $obj_asitlist->set_list_created_by($user->getLoggedInUserId());
                    $obj_asitlist->save();
                    $lastInsertId = $obj_asitlist->getAdapter()->lastInsertId();
                    if (count($obj_form->list_other_category->getValue()) > 0) {
                        $obj_listcat = new Application_Model_ListCategoryLogic(-1);
                        foreach ($obj_form->list_other_category->getValue() as $category) {
                            $obj_listcat->insertCategory($lastInsertId, $category);
                        }
                    }
                    $obj_list_meta = new Application_Model_ListMetaLogic(-1);
                    $obj_list_meta->set_list_id($lastInsertId);
                    $obj_list_meta->set_list_fb($obj_form->list_fb->getValue());
                    $obj_list_meta->set_list_tweet($obj_form->list_tweet->getValue());
                    $obj_list_meta->set_list_insta($obj_form->list_insta->getValue());
                    $obj_list_meta->set_list_amenities(implode(',', $obj_form->list_amenities->getValue()));
                    $obj_list_meta->set_list_target(implode(',', $obj_form->list_target->getValue()));
                    $obj_list_meta->set_list_tags($obj_form->list_tags->getValue());
                    $obj_list_meta->set_list_updated_by($user->getLoggedInUserId());
                    $obj_list_meta->set_list_created_by($user->getLoggedInUserId());
                    $obj_list_meta->save();

                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "Listing Added Successfully!!!";
                    $this->_redirect("dynasty/list/index");
                }
            }
        } else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function editAction() {
        if (Application_Model_RolePermissionLogic::isPermitted("List:Edit")) {
            $id = $this->_getParam("id");
            $obj_form = new Application_Form_List();
            $obj_asitlist = new Application_Model_List($id);
            $obj_listcat = new Application_Model_ListCategoryLogic(-1);
            $obj_form->list_title->setValue($obj_asitlist->get_list_title());
            $obj_form->list_category->setValue($obj_asitlist->get_list_category());
            $obj_form->list_short_desc->setValue($obj_asitlist->get_list_short_desc());
            $obj_form->list_desc->setValue($obj_asitlist->get_list_desc());
            $obj_form->list_image->setRequired(false);
            $obj_form->list_tag_line->setValue($obj_asitlist->get_list_tag_line());
            $obj_form->list_address->setValue($obj_asitlist->get_list_address());
            $obj_form->list_city->setValue($obj_asitlist->get_list_city());
            $obj_form->list_phone->setValue($obj_asitlist->get_list_phone());
            $obj_form->list_email->setValue($obj_asitlist->get_list_email());
            $obj_form->list_website->setValue($obj_asitlist->get_list_website());
            $categories = array();
            foreach ($obj_listcat->getActiveCategory($obj_asitlist->get_id()) as $category) {
                array_push($categories, $category->category_id);
            }
            $obj_form->list_other_category->setValue($categories);
            $obj_lmeta = new Application_Model_ListMetaLogic(-1);
            $obj_list_meta = $obj_lmeta->getMetaByListId($id);
            $obj_form->list_fb->setValue($obj_list_meta->get_list_fb());
            $obj_form->list_tweet->setValue($obj_list_meta->get_list_tweet());
            $obj_form->list_insta->setValue($obj_list_meta->get_list_insta());
            $obj_form->list_rate_ambience->setValue($obj_asitlist->get_list_rate_ambience());
            $obj_form->list_rate_service->setValue($obj_asitlist->get_list_rate_service());
            $obj_form->list_rate_food->setValue($obj_asitlist->get_list_rate_food());
            $obj_form->list_rate_value->setValue($obj_asitlist->get_list_rate_value());
            $obj_form->list_amenities->setValue(explode(',', $obj_list_meta->get_list_amenities()));
            $obj_form->list_target->setValue(explode(',', $obj_list_meta->get_list_target()));
            $obj_form->list_tags->setValue($obj_list_meta->get_list_tags());
            $this->view->form = $obj_form;
            if ($this->getRequest()->isPost()) {
                $data = $this->getRequest()->getPost();
                if ($obj_form->isValid($data)) {
                    //Zend_Debug::dump($obj_form->list_other_category->getValue());
                    $user = new Application_Model_UserLogic(-1);
                    $obj_asitlist->set_list_title($obj_form->list_title->getValue());
                    $obj_asitlist->set_list_category($obj_form->list_category->getValue());
                    $obj_asitlist->set_list_short_desc($obj_form->list_short_desc->getValue());
                    $obj_asitlist->set_list_desc($obj_form->list_desc->getValue());
                    if (count(explode('.', $obj_form->list_image->getValue())) > 1) {
                        $obj_asitlist->set_list_image($obj_form->list_image->getValue());
                    }
                    $obj_asitlist->set_list_tag_line($obj_form->list_tag_line->getValue());
                    $obj_asitlist->set_list_address($obj_form->list_address->getValue());
                    $obj_asitlist->set_list_city($obj_form->list_city->getValue());
                    $obj_asitlist->set_list_phone($obj_form->list_phone->getValue());
                    $obj_asitlist->set_list_email($obj_form->list_email->getValue());
                    $obj_asitlist->set_list_website($obj_form->list_website->getValue());
                    $obj_asitlist->set_list_updated_by($user->getLoggedInUserId());
                    $obj_asitlist->save();
                    if (count($obj_form->list_other_category->getValue()) > 0) {
                        $obj_listcat->removeByListId($obj_asitlist->get_id());
                        foreach ($obj_form->list_other_category->getValue() as $category) {
                            $obj_listcat->insertCategory($obj_asitlist->get_id(), $category);
                        }
                    }
                    $obj_list_meta->set_list_fb($obj_form->list_fb->getValue());
                    $obj_list_meta->set_list_tweet($obj_form->list_tweet->getValue());
                    $obj_list_meta->set_list_insta($obj_form->list_insta->getValue());
                    $obj_list_meta->set_list_amenities(implode(',', $obj_form->list_amenities->getValue()));
                    $obj_list_meta->set_list_target(implode(',', $obj_form->list_target->getValue()));
                    $obj_list_meta->set_list_tags($obj_form->list_tags->getValue());
                    $obj_asitlist->set_list_rate_ambience($obj_form->list_rate_ambience->getValue());
                    $obj_asitlist->set_list_rate_food($obj_form->list_rate_food->getValue());
                    $obj_asitlist->set_list_rate_service($obj_form->list_rate_service->getValue());
                    $obj_asitlist->set_list_rate_value($obj_form->list_rate_value->getValue());
                    $obj_list_meta->set_list_updated_by($user->getLoggedInUserId());
                    $obj_list_meta->save();

                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "Listing Updated Successfully!!!";
                    $this->_redirect("dynasty/list/index");
                }
            }
        } else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function deleteAction() {
        if (Application_Model_RolePermissionLogic::isPermitted("List:Delete")) {
            $id = $this->_getParam("id");
            $obj_asitlist = new Application_Model_ListLogic($id);
            $obj_asitlist->set_list_status('D');
            $obj_asitlist->save();

            $sess = new Zend_Session_Namespace("msg");
            $sess->msg = "Listing Removed Successfully!!!";
            $this->_redirect("dynasty/list/index");
        } else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function imageAction() {
        if (Application_Model_RolePermissionLogic::isPermitted("List:Master")) {
            $this->view->listId = $listId = $this->_getParam("id");
            $obj_asitlist = new Application_Model_ListImageLogic(-1);
            $this->view->images = $obj_asitlist->getActiveImage($listId);
            $obj_form = new Application_Form_ListImage();
            $obj_form->list_id->setValue($listId);
            $this->view->form = $obj_form;
            if ($this->getRequest()->isPost()) {
                $data = $this->getRequest()->getPost();
                if ($obj_form->isValid($data)) {
                    $user = new Application_Model_UserLogic(-1);
                    $obj_asitlist->set_list_id($obj_form->list_id->getValue());
                    $obj_asitlist->set_image_path($obj_form->list_image_path->getValue());
                    $obj_asitlist->set_list_image_status('A');
                    $obj_asitlist->set_list_image_updated_by($user->getLoggedInUserId());
                    $obj_asitlist->set_list_image_created_by($user->getLoggedInUserId());
                    $obj_asitlist->save();

                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "Image Added Successfully!!!";
                    $this->_redirect("dynasty/list/image/id/" . $obj_form->list_id->getValue());
                }
            }
        } else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function deleteImageAction() {
        if (Application_Model_RolePermissionLogic::isPermitted("List:Delete")) {
            $id = $this->_getParam("id");
            $obj_asitlist = new Application_Model_ListImageLogic($id);
            unlink(Application_Model_Cache_Config::getConfig("UPLOAD_FOLDER_NAME") . '/' . Application_Model_Cache_Config::getConfig("LIST_FOLDER") . '/' . $obj_asitlist->get_image_path());
            $obj_asitlist->remove();

            $sess = new Zend_Session_Namespace("msg");
            $sess->msg = "Image Removed Successfully!!!";
            $this->_redirect("dynasty/list/image/id/" . $obj_asitlist->get_list_id());
        } else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

}
